/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.map.operation.PutBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.map.tx.MapTxnOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class TxnSetOperation
extends BasePutOperation
implements MapTxnOperation {
    private long version;
    private transient boolean shouldBackup;
    private String ownerUuid;

    public TxnSetOperation() {
    }

    public TxnSetOperation(String name, Data dataKey, Data value, long version) {
        super(name, dataKey, value);
        this.version = version;
    }

    public TxnSetOperation(String name, Data dataKey, Data value, long version, long ttl) {
        super(name, dataKey, value);
        this.version = version;
        this.ttl = ttl;
    }

    @Override
    public boolean shouldWait() {
        return !this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.getThreadId());
    }

    @Override
    public void run() {
        this.recordStore.unlock(this.dataKey, this.ownerUuid, this.getThreadId());
        Record record = this.recordStore.getRecord(this.dataKey);
        if (record == null || this.version == record.getVersion()) {
            this.recordStore.set(this.dataKey, this.dataValue, this.ttl);
            this.shouldBackup = true;
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void setOwnerUuid(String ownerUuid) {
        this.ownerUuid = ownerUuid;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        RecordInfo replicationInfo = this.mapService.createRecordInfo(this.mapContainer, this.recordStore.getRecord(this.dataKey));
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo, true);
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(false);
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.version);
        out.writeUTF(this.ownerUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readLong();
        this.ownerUuid = in.readUTF();
    }
}

