/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.Set;

public class EvictKeysBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
DataSerializable {
    MapKeySet mapKeySet;
    MapService mapService;
    RecordStore recordStore;

    public EvictKeysBackupOperation() {
    }

    public EvictKeysBackupOperation(String name, Set<Data> keys) {
        super(name);
        this.mapKeySet = new MapKeySet(keys);
    }

    @Override
    public void beforeRun() throws Exception {
        this.mapService = (MapService)this.getService();
        this.recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
    }

    @Override
    public void run() {
        Set<Data> keys = this.mapKeySet.getKeySet();
        for (Data key : keys) {
            if (this.recordStore.isLocked(key)) continue;
            this.recordStore.evict(key);
        }
    }

    public Set<Data> getKeys() {
        return this.mapKeySet.getKeySet();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.mapKeySet.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapKeySet = new MapKeySet();
        this.mapKeySet.readData(in);
    }

    public String toString() {
        return "EvictKeysBackupOperation{}";
    }
}

