/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.serialization.Data;

public abstract class AbstractRecord<V>
implements Record<V> {
    protected RecordStatistics statistics;
    protected Data key;
    protected long version;
    protected long evictionCriteriaNumber;

    public AbstractRecord(Data key, boolean statisticsEnabled) {
        this.key = key;
        if (statisticsEnabled) {
            this.statistics = new RecordStatistics();
        }
        this.version = 0L;
    }

    public AbstractRecord() {
    }

    @Override
    public final Data getKey() {
        return this.key;
    }

    @Override
    public final RecordStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final void setStatistics(RecordStatistics stats) {
        this.statistics = stats;
    }

    @Override
    public final long getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(long version) {
        this.version = version;
    }

    @Override
    public final void onAccess() {
        if (this.statistics != null) {
            this.statistics.access();
        }
    }

    @Override
    public final void onStore() {
        if (this.statistics != null) {
            this.statistics.store();
        }
    }

    @Override
    public final void onUpdate() {
        if (this.statistics != null) {
            this.statistics.update();
        }
        ++this.version;
    }

    @Override
    public long getEvictionCriteriaNumber() {
        return this.evictionCriteriaNumber;
    }

    @Override
    public void setEvictionCriteriaNumber(long evictionCriteriaNumber) {
        this.evictionCriteriaNumber = evictionCriteriaNumber;
    }

    @Override
    public long getCost() {
        int size = 0;
        size = (int)((long)size + (4L + (this.statistics == null ? 0L : this.statistics.size())));
        size += 8;
        size += 8;
        return size += 4 + this.key.getHeapCost();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecord that = (AbstractRecord)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Record{key=" + this.key + '}';
    }
}

