/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AbstractUnlockRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected Data key;
    private long threadId;
    private boolean force;

    public AbstractUnlockRequest() {
    }

    public AbstractUnlockRequest(Data key, long threadId) {
        this.key = key;
        this.threadId = threadId;
    }

    protected AbstractUnlockRequest(Data key, long threadId, boolean force) {
        this.key = key;
        this.threadId = threadId;
        this.force = force;
    }

    protected String getName() {
        return (String)this.getClientEngine().toObject(this.key);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    @Override
    protected final Operation prepareOperation() {
        return new UnlockOperation(this.getNamespace(), this.key, this.threadId, this.force);
    }

    protected abstract ObjectNamespace getNamespace();

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("tid", this.threadId);
        writer.writeBoolean("force", this.force);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("tid");
        this.force = reader.readBoolean("force");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }
}

