/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CollectionContainsOperation
extends CollectionOperation {
    Set<Data> valueSet;

    public CollectionContainsOperation() {
    }

    public CollectionContainsOperation(String name, Set<Data> valueSet) {
        super(name);
        this.valueSet = valueSet;
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_CONTAINS;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.response = this.getOrCreateContainer().contains(this.valueSet);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.valueSet.size());
        for (Data value : this.valueSet) {
            value.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.valueSet = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = new Data();
            value.readData(in);
            this.valueSet.add(value);
        }
    }
}

