/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractJoiner;
import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.MulticastListener;
import com.hazelcast.cluster.TcpIpJoiner;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.RandomPicker;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MulticastJoiner
extends AbstractJoiner {
    private final AtomicInteger currentTryCount = new AtomicInteger(0);
    private final AtomicInteger maxTryCount = new AtomicInteger(this.calculateTryCount());
    private static final int publishInterval = 100;

    public MulticastJoiner(Node node) {
        super(node);
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        int tryCount = 0;
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
        while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            Address masterAddressNow = this.getTargetAddress();
            if (masterAddressNow == null) {
                masterAddressNow = this.findMasterWithMulticast();
            }
            this.node.setMasterAddress(masterAddressNow);
            String msg = "Joining to master node: " + this.node.getMasterAddress();
            this.logger.finest(msg);
            this.systemLogService.logJoin(msg);
            if (this.node.getMasterAddress() == null || this.node.getThisAddress().equals(this.node.getMasterAddress())) {
                TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
                if (tcpIpConfig != null && tcpIpConfig.isEnabled()) {
                    this.doTCP(joined);
                } else {
                    this.node.setAsMaster();
                }
                return;
            }
            if (++tryCount > 49) {
                this.failedJoiningToMaster(true, tryCount);
            }
            if (!this.node.getMasterAddress().equals(this.node.getThisAddress())) {
                this.connectAndSendJoinRequest(this.node.getMasterAddress());
            } else {
                this.node.setMasterAddress(null);
                tryCount = 0;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
    }

    private void doTCP(AtomicBoolean joined) {
        this.node.setMasterAddress(null);
        this.logger.finest("Multicast couldn't find cluster. Trying TCP/IP");
        new TcpIpJoiner(this.node).join(joined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchForOtherClusters() {
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        MulticastListener listener = new MulticastListener(){

            @Override
            public void onMessage(Object msg) {
                MulticastJoiner.this.systemLogService.logJoin("MulticastListener onMessage " + msg);
                if (msg != null && msg instanceof JoinMessage) {
                    JoinMessage joinRequest = (JoinMessage)msg;
                    if (MulticastJoiner.this.node.getThisAddress() != null && !MulticastJoiner.this.node.getThisAddress().equals(joinRequest.getAddress())) {
                        q.add(joinRequest);
                    }
                }
            }
        };
        this.node.multicastService.addMulticastListener(listener);
        this.node.multicastService.send(this.node.createJoinRequest());
        this.systemLogService.logJoin("Sent multicast join request");
        try {
            JoinMessage joinInfo = (JoinMessage)q.poll(3L, TimeUnit.SECONDS);
            if (joinInfo != null) {
                if (joinInfo.getMemberCount() == 1) {
                    Thread.sleep((long)this.node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L * 2L);
                }
                if (this.shouldMerge(joinInfo)) {
                    this.logger.warning(this.node.getThisAddress() + " is merging [multicast] to " + joinInfo.getAddress());
                    this.startClusterMerge(joinInfo.getAddress());
                }
            }
        }
        catch (InterruptedException ignored) {
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
        }
        finally {
            this.node.multicastService.removeMulticastListener(listener);
        }
    }

    @Override
    public String getType() {
        return "multicast";
    }

    private boolean connectAndSendJoinRequest(Address masterAddress) {
        if (masterAddress == null || masterAddress.equals(this.node.getThisAddress())) {
            throw new IllegalArgumentException();
        }
        Connection conn = this.node.connectionManager.getOrConnect(masterAddress);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Master connection " + conn);
        }
        this.systemLogService.logJoin("Master connection " + conn);
        if (conn != null) {
            return this.node.clusterService.sendJoinRequest(masterAddress, true);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connecting to master node: " + masterAddress);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address findMasterWithMulticast() {
        try {
            JoinRequest joinRequest = this.node.createJoinRequest();
            while (this.node.isActive() && this.currentTryCount.incrementAndGet() <= this.maxTryCount.get()) {
                joinRequest.setTryCount(this.currentTryCount.get());
                this.node.multicastService.send(joinRequest);
                if (this.node.getMasterAddress() == null) {
                    Thread.sleep(100L);
                    continue;
                }
                Address address = this.node.getMasterAddress();
                return address;
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
        }
        finally {
            this.currentTryCount.set(0);
        }
        return null;
    }

    private int calculateTryCount() {
        int lastDigits;
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        int timeoutSeconds = networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds();
        int tryCountCoefficient = 10;
        int tryCount = timeoutSeconds * tryCountCoefficient;
        String host = this.node.getThisAddress().getHost();
        try {
            lastDigits = Integer.parseInt(host.substring(host.lastIndexOf(46) + 1));
        }
        catch (NumberFormatException e) {
            lastDigits = RandomPicker.getInt(512);
        }
        int portDiff = this.node.getThisAddress().getPort() - networkConfig.getPort();
        return tryCount += (lastDigits %= 100) + portDiff * timeoutSeconds * 3;
    }

    public void onReceivedJoinRequest(JoinRequest joinRequest) {
        if (joinRequest.getUuid().compareTo(this.node.localMember.getUuid()) < 0) {
            this.maxTryCount.incrementAndGet();
        }
    }
}

