/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.topic.TopicPortableHook;
import com.hazelcast.topic.TopicService;
import com.hazelcast.topic.client.PortableMessage;
import java.io.IOException;
import java.security.Permission;

public class AddMessageListenerRequest
extends CallableClientRequest
implements Portable,
SecureRequest,
RetryableRequest {
    private String name;

    public AddMessageListenerRequest() {
    }

    public AddMessageListenerRequest(String name) {
        this.name = name;
    }

    public String call() throws Exception {
        TopicService service = (TopicService)this.getService();
        ClientEngine clientEngine = this.getClientEngine();
        ClientEndpoint endpoint = this.getEndpoint();
        MessageListenerImpl listener = new MessageListenerImpl(endpoint, clientEngine, this.getCallId());
        String registrationId = service.addMessageListener(this.name, listener);
        endpoint.setListenerRegistration("hz:impl:topicService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public int getFactoryId() {
        return TopicPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new TopicPermission(this.name, "listen");
    }

    private static class MessageListenerImpl
    implements MessageListener {
        private final ClientEndpoint endpoint;
        private final ClientEngine clientEngine;
        private final int callId;

        public MessageListenerImpl(ClientEndpoint endpoint, ClientEngine clientEngine, int callId) {
            this.endpoint = endpoint;
            this.clientEngine = clientEngine;
            this.callId = callId;
        }

        public void onMessage(Message message) {
            if (!this.endpoint.live()) {
                return;
            }
            Data messageData = this.clientEngine.toData(message.getMessageObject());
            String publisherUuid = message.getPublishingMember().getUuid();
            PortableMessage portableMessage = new PortableMessage(messageData, message.getPublishTime(), publisherUuid);
            this.endpoint.sendEvent(portableMessage, this.callId);
        }
    }
}

