/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractJoiner;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.Clock;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpIpJoiner
extends AbstractJoiner {
    private static final int MAX_PORT_TRIES = 3;
    private volatile boolean claimingMaster = false;

    public TcpIpJoiner(Node node) {
        super(node);
    }

    private void joinViaTargetMember(AtomicBoolean joined, Address targetAddress, long maxJoinMillis) {
        try {
            if (targetAddress == null) {
                throw new IllegalArgumentException("Invalid target address -> NULL");
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Joining over target member " + targetAddress);
            }
            if (targetAddress.equals(this.node.getThisAddress()) || this.isLocalAddress(targetAddress)) {
                this.node.setAsMaster();
                return;
            }
            long joinStartTime = Clock.currentTimeMillis();
            Connection connection = null;
            while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
                connection = this.node.connectionManager.getOrConnect(targetAddress);
                if (connection == null) {
                    Thread.sleep(2000L);
                    continue;
                }
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Sending joinRequest " + targetAddress);
                }
                this.node.clusterService.sendJoinRequest(targetAddress, true);
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinViaPossibleMembers(AtomicBoolean joined) {
        try {
            this.node.getFailedConnections().clear();
            Collection<Address> colPossibleAddresses = this.getPossibleAddresses();
            colPossibleAddresses.remove(this.node.getThisAddress());
            for (Address possibleAddress : colPossibleAddresses) {
                this.logger.info("Connecting to possible member: " + possibleAddress);
                this.node.connectionManager.getOrConnect(possibleAddress);
            }
            boolean foundConnection = false;
            int numberOfSeconds = 0;
            int connectionTimeoutSeconds = this.getConnTimeoutSeconds();
            while (!foundConnection && numberOfSeconds < connectionTimeoutSeconds) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Removing failedConnections: " + this.node.getFailedConnections());
                }
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) break;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("We are going to try to connect to each address" + colPossibleAddresses);
                }
                for (Address possibleAddress : colPossibleAddresses) {
                    Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                    if (conn == null) continue;
                    foundConnection = true;
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Found a connection and sending join request to " + possibleAddress);
                    }
                    this.node.clusterService.sendJoinRequest(possibleAddress, true);
                }
                if (foundConnection) continue;
                Thread.sleep(1000L);
                ++numberOfSeconds;
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("FOUND " + foundConnection);
            }
            if (!foundConnection) {
                this.logger.finest("This node will assume master role since no possible member where connected to.");
                this.node.setAsMaster();
            } else if (!this.node.joined()) {
                int totalSleep = connectionTimeoutSeconds - numberOfSeconds;
                for (int i = 0; i < totalSleep * 2 && !this.node.joined(); ++i) {
                    this.logger.finest("Waiting for join request answer, sleeping for 500 ms...");
                    Thread.sleep(500L);
                    Address masterAddress = this.node.getMasterAddress();
                    if (masterAddress == null) continue;
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Sending join request to " + masterAddress);
                    }
                    this.node.clusterService.sendJoinRequest(masterAddress, true);
                }
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) {
                    this.logger.finest("This node will assume master role since none of the possible members accepted join request.");
                    this.node.setAsMaster();
                } else if (!this.node.joined()) {
                    boolean masterCandidate = true;
                    for (Address address : colPossibleAddresses) {
                        if (this.node.connectionManager.getConnection(address) == null || this.node.getThisAddress().hashCode() <= address.hashCode()) continue;
                        masterCandidate = false;
                    }
                    if (masterCandidate) {
                        this.claimingMaster = true;
                        LinkedList<InternalCompletableFuture> responses = new LinkedList<InternalCompletableFuture>();
                        for (Address address : colPossibleAddresses) {
                            if (this.node.getConnectionManager().getConnection(address) == null) continue;
                            this.logger.finest("Claiming myself as master node!");
                            InternalCompletableFuture future = this.node.nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", (Operation)new MasterClaim(), address).setTryCount(1).invoke();
                            responses.add(future);
                        }
                        long maxWait = TimeUnit.SECONDS.toMillis(10L);
                        long waitTime = 0L;
                        boolean allApprovedAsMaster = true;
                        for (Future future : responses) {
                            if (!allApprovedAsMaster || waitTime > maxWait) {
                                allApprovedAsMaster = false;
                                break;
                            }
                            long t = Clock.currentTimeMillis();
                            try {
                                allApprovedAsMaster &= ((Boolean)future.get(1L, TimeUnit.SECONDS)).booleanValue();
                            }
                            catch (Exception e) {
                                this.logger.finest(e);
                                allApprovedAsMaster = false;
                            }
                            finally {
                                waitTime += Clock.currentTimeMillis() - t;
                            }
                        }
                        if (allApprovedAsMaster) {
                            if (this.logger.isFinestEnabled()) {
                                this.logger.finest(this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " possible addresses " + colPossibleAddresses.size() + " " + colPossibleAddresses);
                            }
                            this.node.setAsMaster();
                            return;
                        }
                        this.lookForMaster(colPossibleAddresses);
                    } else {
                        this.lookForMaster(colPossibleAddresses);
                    }
                }
            }
            colPossibleAddresses.clear();
            this.node.getFailedConnections().clear();
        }
        catch (Throwable t) {
            this.logger.severe(t);
        }
    }

    protected int getConnTimeoutSeconds() {
        return this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
    }

    private void lookForMaster(Collection<Address> colPossibleAddresses) throws InterruptedException {
        int tryCount = 0;
        this.claimingMaster = false;
        while (!this.node.joined() && tryCount++ < 20 && this.node.getMasterAddress() == null) {
            this.connectAndSendJoinRequest(colPossibleAddresses);
            Thread.sleep(1000L);
        }
        int requestCount = 0;
        colPossibleAddresses.removeAll(this.node.getFailedConnections());
        if (colPossibleAddresses.size() == 0) {
            this.node.setAsMaster();
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " no possible addresses without failed connection");
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(this.node.getThisAddress() + " joining to master " + this.node.getMasterAddress() + ", group " + this.node.getConfig().getGroupConfig().getName());
        }
        while (this.node.isActive() && !this.node.joined()) {
            Thread.sleep(1000L);
            Address master = this.node.getMasterAddress();
            if (master != null) {
                this.node.clusterService.sendJoinRequest(master, true);
                if (requestCount++ <= this.node.getGroupProperties().MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() + 10) continue;
                this.logger.warning("Couldn't join to the master : " + master);
                return;
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(this.node.getThisAddress() + " couldn't find a master! but there was connections available: " + colPossibleAddresses);
            }
            return;
        }
    }

    private Address getRequiredMemberAddress() {
        block8: {
            TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
            String host = tcpIpConfig.getRequiredMember();
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(host, this.config.getNetworkConfig().getPort());
                if (AddressUtil.isIpAddress(addressHolder.address)) {
                    return new Address(addressHolder.address, addressHolder.port);
                }
                InterfacesConfig interfaces = this.config.getNetworkConfig().getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress[] inetAddresses = InetAddress.getAllByName(addressHolder.address);
                    if (inetAddresses.length > 1) {
                        for (InetAddress inetAddress : inetAddresses) {
                            if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                            return new Address(inetAddress, addressHolder.port);
                        }
                    } else {
                        InetAddress inetAddress = inetAddresses[0];
                        if (AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) {
                            return new Address(addressHolder.address, addressHolder.port);
                        }
                    }
                    break block8;
                }
                return new Address(addressHolder.address, addressHolder.port);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return null;
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        Address targetAddress = this.getTargetAddress();
        if (targetAddress != null) {
            long maxJoinMergeTargetMillis = this.node.getGroupProperties().MAX_JOIN_MERGE_TARGET_SECONDS.getInteger() * 1000;
            this.joinViaTargetMember(joined, targetAddress, maxJoinMergeTargetMillis);
            if (!joined.get()) {
                this.joinViaPossibleMembers(joined);
            }
        } else if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            Address requiredMember = this.getRequiredMemberAddress();
            long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
            this.joinViaTargetMember(joined, requiredMember, maxJoinMillis);
        } else {
            this.joinViaPossibleMembers(joined);
        }
    }

    private Collection<Address> getPossibleAddresses() {
        Collection<String> possibleMembers = this.getMembers();
        HashSet<Address> possibleAddresses = new HashSet<Address>();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (String possibleMember : possibleMembers) {
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(possibleMember);
                boolean portIsDefined = addressHolder.port != -1 || !networkConfig.isPortAutoIncrement();
                int count = portIsDefined ? 1 : 3;
                int port = addressHolder.port != -1 ? addressHolder.port : networkConfig.getPort();
                AddressUtil.AddressMatcher addressMatcher = null;
                try {
                    addressMatcher = AddressUtil.getAddressMatcher(addressHolder.address);
                }
                catch (AddressUtil.InvalidAddressException ignore) {
                    // empty catch block
                }
                if (addressMatcher != null) {
                    Collection<String> matchedAddresses = addressMatcher.isIPv4() ? AddressUtil.getMatchingIpv4Addresses(addressMatcher) : Collections.singleton(addressHolder.address);
                    for (String matchedAddress : matchedAddresses) {
                        this.addPossibleAddresses(possibleAddresses, null, InetAddress.getByName(matchedAddress), port, count);
                    }
                    continue;
                }
                String host = addressHolder.address;
                InterfacesConfig interfaces = networkConfig.getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress[] inetAddresses = InetAddress.getAllByName(host);
                    if (inetAddresses.length > 1) {
                        for (InetAddress inetAddress : inetAddresses) {
                            if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                            this.addPossibleAddresses(possibleAddresses, null, inetAddress, port, count);
                        }
                        continue;
                    }
                    InetAddress inetAddress = inetAddresses[0];
                    if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                    this.addPossibleAddresses(possibleAddresses, host, null, port, count);
                    continue;
                }
                this.addPossibleAddresses(possibleAddresses, host, null, port, count);
            }
            catch (UnknownHostException e) {
                this.logger.warning(e);
            }
        }
        return possibleAddresses;
    }

    private void addPossibleAddresses(Set<Address> possibleAddresses, String host, InetAddress inetAddress, int port, int count) throws UnknownHostException {
        for (int i = 0; i < count; ++i) {
            Address address;
            int currentPort = port + i;
            Address address2 = address = host != null ? new Address(host, currentPort) : new Address(inetAddress, currentPort);
            if (this.isLocalAddress(address)) continue;
            possibleAddresses.add(address);
        }
    }

    private boolean isLocalAddress(Address address) throws UnknownHostException {
        Address thisAddress = this.node.getThisAddress();
        boolean local = thisAddress.getInetSocketAddress().equals(address.getInetSocketAddress());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(address + " is local? " + local);
        }
        return local;
    }

    protected Collection<String> getMembers() {
        return TcpIpJoiner.getConfigurationMembers(this.config);
    }

    public static Collection<String> getConfigurationMembers(Config config) {
        TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        List<String> configMembers = tcpIpConfig.getMembers();
        HashSet<String> possibleMembers = new HashSet<String>();
        for (String member : configMembers) {
            String[] members = member.split("[,; ]");
            Collections.addAll(possibleMembers, members);
        }
        return possibleMembers;
    }

    @Override
    public void searchForOtherClusters() {
        Collection<Address> colPossibleAddresses;
        try {
            colPossibleAddresses = this.getPossibleAddresses();
        }
        catch (Throwable e) {
            this.logger.severe(e);
            return;
        }
        colPossibleAddresses.remove(this.node.getThisAddress());
        for (Member member : this.node.getClusterService().getMembers()) {
            colPossibleAddresses.remove(((MemberImpl)member).getAddress());
        }
        if (colPossibleAddresses.isEmpty()) {
            return;
        }
        for (Address possibleAddress : colPossibleAddresses) {
            JoinRequest response;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(this.node.getThisAddress() + " is connecting to " + possibleAddress);
            }
            this.node.connectionManager.getOrConnect(possibleAddress, true);
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                return;
            }
            Connection conn = this.node.connectionManager.getConnection(possibleAddress);
            if (conn == null || (response = this.node.clusterService.checkJoinInfo(possibleAddress)) == null || !this.shouldMerge(response)) continue;
            this.logger.warning(this.node.getThisAddress() + " is merging [tcp/ip] to " + possibleAddress);
            this.setTargetAddress(possibleAddress);
            this.startClusterMerge(possibleAddress);
            return;
        }
    }

    @Override
    public String getType() {
        return "tcp-ip";
    }

    public static class MasterClaim
    extends AbstractOperation
    implements JoinOperation {
        private transient boolean approvedAsMaster = false;

        @Override
        public void run() {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            Node node = nodeEngine.getNode();
            Joiner joiner = node.getJoiner();
            ILogger logger = node.getLogger(this.getClass().getName());
            if (joiner instanceof TcpIpJoiner) {
                TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)joiner;
                Address endpoint = this.getCallerAddress();
                Address masterAddress = node.getMasterAddress();
                this.approvedAsMaster = !tcpIpJoiner.claimingMaster && !node.isMaster() && (masterAddress == null || masterAddress.equals(endpoint));
            } else {
                this.approvedAsMaster = false;
                logger.warning("This node requires MulticastJoin strategy!");
            }
            if (logger.isFinestEnabled()) {
                logger.finest("Sending '" + this.approvedAsMaster + "' for master claim of node: " + this.getCallerAddress());
            }
        }

        @Override
        public boolean returnsResponse() {
            return true;
        }

        @Override
        public Object getResponse() {
            return this.approvedAsMaster;
        }
    }
}

