/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.txn;

import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.operations.CountOperation;
import com.hazelcast.multimap.operations.GetAllOperation;
import com.hazelcast.multimap.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.txn.MultiMapTransactionLog;
import com.hazelcast.multimap.txn.TransactionLogKey;
import com.hazelcast.multimap.txn.TxnGenerateRecordIdOperation;
import com.hazelcast.multimap.txn.TxnLockAndGetOperation;
import com.hazelcast.multimap.txn.TxnPutOperation;
import com.hazelcast.multimap.txn.TxnRemoveAllOperation;
import com.hazelcast.multimap.txn.TxnRemoveOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class TransactionalMultiMapProxySupport
extends AbstractDistributedObject<MultiMapService>
implements TransactionalObject {
    protected final String name;
    protected final TransactionSupport tx;
    protected final MultiMapConfig config;
    private long version = -1L;
    private final Map<Data, Collection<MultiMapRecord>> txMap = new HashMap<Data, Collection<MultiMapRecord>>();

    protected TransactionalMultiMapProxySupport(NodeEngine nodeEngine, MultiMapService service, String name, TransactionSupport tx) {
        super(nodeEngine, service);
        this.name = name;
        this.tx = tx;
        this.config = nodeEngine.getConfig().findMultiMapConfig(name);
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    protected boolean putInternal(Data key, Data value) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        this.throwExceptionIfNull(value);
        Collection<MultiMapRecord> coll = this.txMap.get(key);
        long recordId = -1L;
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        if (coll == null) {
            MultiMapResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            recordId = response.getNextRecordId();
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            this.txMap.put(key, coll);
            log = new MultiMapTransactionLog(key, this.name, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        MultiMapRecord record = new MultiMapRecord(this.config.isBinary() ? value : this.getNodeEngine().toObject(value));
        if (coll.add(record)) {
            if (recordId == -1L) {
                recordId = this.nextId(key);
            }
            record.setRecordId(recordId);
            TxnPutOperation operation = new TxnPutOperation(this.name, key, value, recordId);
            log.addOperation(operation);
            return true;
        }
        return false;
    }

    protected boolean removeInternal(Data key, Data value) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        this.throwExceptionIfNull(value);
        Collection<MultiMapRecord> coll = this.txMap.get(key);
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        if (coll == null) {
            MultiMapResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            this.txMap.put(key, coll);
            log = new MultiMapTransactionLog(key, this.name, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        MultiMapRecord record = new MultiMapRecord(this.config.isBinary() ? value : this.getNodeEngine().toObject(value));
        Iterator<MultiMapRecord> iterator = coll.iterator();
        long recordId = -1L;
        while (iterator.hasNext()) {
            MultiMapRecord r = iterator.next();
            if (!r.equals(record)) continue;
            iterator.remove();
            recordId = r.getRecordId();
            break;
        }
        if (this.version != -1L || recordId != -1L) {
            TxnRemoveOperation operation = new TxnRemoveOperation(this.name, key, recordId, value);
            log.addOperation(operation);
            return recordId != -1L;
        }
        return false;
    }

    protected Collection<MultiMapRecord> removeAllInternal(Data key) {
        MultiMapTransactionLog log;
        this.throwExceptionIfNull(key);
        long timeout = this.tx.getTimeoutMillis();
        long ttl = timeout * 3L / 2L;
        Collection<MultiMapRecord> coll = this.txMap.get(key);
        if (coll == null) {
            MultiMapResponse response = this.lockAndGet(key, timeout, ttl);
            if (response == null) {
                throw new ConcurrentModificationException("Transaction couldn't obtain lock " + this.getThreadId());
            }
            this.version = response.getTxVersion();
            coll = this.createCollection(response.getRecordCollection(this.getNodeEngine()));
            log = new MultiMapTransactionLog(key, this.name, ttl, this.getThreadId(), this.version);
            this.tx.addTransactionLog(log);
        } else {
            log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
        }
        this.txMap.put(key, this.createCollection());
        TxnRemoveAllOperation operation = new TxnRemoveAllOperation(this.name, key, coll);
        log.addOperation(operation);
        return coll;
    }

    protected Collection<MultiMapRecord> getInternal(Data key) {
        this.throwExceptionIfNull(key);
        Collection<MultiMapRecord> coll = this.txMap.get(key);
        if (coll == null) {
            GetAllOperation operation = new GetAllOperation(this.name, key);
            try {
                int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(key);
                InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
                MultiMapResponse response = (MultiMapResponse)f.get();
                coll = response.getRecordCollection(this.getNodeEngine());
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return coll;
    }

    protected int valueCountInternal(Data key) {
        this.throwExceptionIfNull(key);
        Collection<MultiMapRecord> coll = this.txMap.get(key);
        if (coll == null) {
            CountOperation operation = new CountOperation(this.name, key);
            try {
                int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(key);
                InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
                return (Integer)f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return coll.size();
    }

    public int size() {
        this.checkTransactionState();
        try {
            Map<Integer, Object> results = this.getNodeEngine().getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.SIZE));
            int size = 0;
            for (Object obj : results.values()) {
                if (obj == null) continue;
                Integer result = (Integer)this.getNodeEngine().toObject(obj);
                size += result.intValue();
            }
            for (Data key : this.txMap.keySet()) {
                MultiMapTransactionLog log = (MultiMapTransactionLog)this.tx.getTransactionLog(this.getTxLogKey(key));
                if (log == null) continue;
                size += log.size();
            }
            return size;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private TransactionLogKey getTxLogKey(Data key) {
        return new TransactionLogKey(this.name, key);
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:multiMapService";
    }

    private void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private long getThreadId() {
        return ThreadUtil.getThreadId();
    }

    private MultiMapResponse lockAndGet(Data key, long timeout, long ttl) {
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnLockAndGetOperation operation = new TxnLockAndGetOperation(this.name, key, timeout, ttl, this.getThreadId());
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
            return (MultiMapResponse)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private long nextId(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnGenerateRecordIdOperation operation = new TxnGenerateRecordIdOperation(this.name, key);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
            return (Long)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Collection<MultiMapRecord> createCollection() {
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet<MultiMapRecord>();
        }
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new ArrayList<MultiMapRecord>();
        }
        return null;
    }

    private Collection<MultiMapRecord> createCollection(Collection<MultiMapRecord> coll) {
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet<MultiMapRecord>(coll);
        }
        if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new ArrayList<MultiMapRecord>(coll);
        }
        return null;
    }
}

