/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.ascii.rest.HttpCommand;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.management.ConsoleCommandHandler;
import com.hazelcast.management.ManagementCenterIdentifier;
import com.hazelcast.management.TimedMemberStateFactory;
import com.hazelcast.management.operation.UpdateManagementCenterUrlOperation;
import com.hazelcast.management.request.ClusterPropsRequest;
import com.hazelcast.management.request.ConsoleCommandRequest;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.management.request.EvictLocalMapRequest;
import com.hazelcast.management.request.ExecuteScriptRequest;
import com.hazelcast.management.request.GetLogsRequest;
import com.hazelcast.management.request.GetMapEntryRequest;
import com.hazelcast.management.request.GetMemberSystemPropertiesRequest;
import com.hazelcast.management.request.GetSystemWarningsRequest;
import com.hazelcast.management.request.MapConfigRequest;
import com.hazelcast.management.request.MemberConfigRequest;
import com.hazelcast.management.request.RunGcRequest;
import com.hazelcast.management.request.RuntimeStateRequest;
import com.hazelcast.management.request.ShutdownMemberRequest;
import com.hazelcast.management.request.ThreadDumpRequest;
import com.hazelcast.management.request.VersionMismatchLogRequest;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class ManagementCenterService {
    private static final AtomicBoolean DISPLAYED_HOSTED_MANAGEMENT_CENTER_INFO = new AtomicBoolean(false);
    public static final int HTTP_SUCCESS = 200;
    private final HazelcastInstanceImpl instance;
    private final TaskPollThread taskPollThread;
    private final StateSendThread stateSendThread;
    private final ILogger logger;
    private final ConsoleCommandHandler commandHandler;
    private final ManagementCenterConfig managementCenterConfig;
    private final SerializationService serializationService;
    private final ManagementCenterIdentifier identifier;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final String clusterId;
    private final String securityToken;
    private volatile String managementCenterUrl;
    private volatile boolean urlChanged = false;
    private volatile boolean versionMismatch = false;

    public ManagementCenterService(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.logger = instance.node.getLogger(ManagementCenterService.class);
        this.managementCenterConfig = this.getManagementCenterConfig();
        this.securityToken = this.managementCenterConfig.getSecurityToken();
        this.managementCenterUrl = this.getManagementCenterUrl();
        this.clusterId = this.getClusterId();
        this.commandHandler = new ConsoleCommandHandler(instance);
        this.taskPollThread = new TaskPollThread();
        this.stateSendThread = new StateSendThread();
        this.serializationService = instance.node.getSerializationService();
        this.identifier = this.newManagementCenterIdentifier();
        this.registerListeners();
        this.logHostedManagementCenterMessages();
    }

    private void logHostedManagementCenterMessages() {
        if (this.isHostedManagementCenterEnabled()) {
            if (this.isSecurityTokenAvailable()) {
                this.logHostedManagementCenterLoginUrl();
            } else {
                this.logHostedManagementCenterRegisterUrl();
            }
        }
    }

    private boolean isSecurityTokenAvailable() {
        return !StringUtil.isNullOrEmpty(this.managementCenterConfig.getSecurityToken());
    }

    private String getManagementCenterUrl() {
        if (this.isHostedManagementCenterEnabled()) {
            return this.getHostedManagementCenterUrl();
        }
        return this.managementCenterConfig.getUrl();
    }

    private boolean isHostedManagementCenterEnabled() {
        if (!this.getGroupProperties().HOSTED_MANAGEMENT_ENABLED.getBoolean()) {
            return false;
        }
        return StringUtil.isNullOrEmpty(this.managementCenterConfig.getUrl());
    }

    private GroupProperties getGroupProperties() {
        return this.instance.node.getGroupProperties();
    }

    private String getHostedManagementCenterUrl() {
        return this.getGroupProperties().HOSTED_MANAGEMENT_URL.getString();
    }

    private void registerListeners() {
        if (!this.managementCenterConfig.isEnabled()) {
            return;
        }
        this.instance.getLifecycleService().addLifecycleListener(new LifecycleListenerImpl());
        this.instance.getCluster().addMembershipListener(new MemberListenerImpl());
    }

    private void logHostedManagementCenterLoginUrl() {
        if (this.managementCenterConfig.isEnabled()) {
            this.logger.info("======================================================");
            this.logger.info("You can access your Hazelcast instance at:");
            this.logger.info(this.getHostedManagementCenterUrl() + "/start.do?clusterid=" + this.clusterId);
            this.logger.info("======================================================");
        } else {
            this.logger.info("======================================================");
            this.logger.info("To see your application on the Hosted Management Center, you need to enable the ManagementCenterConfig.");
            this.logger.info("======================================================");
        }
    }

    private void logHostedManagementCenterRegisterUrl() {
        if (!DISPLAYED_HOSTED_MANAGEMENT_CENTER_INFO.compareAndSet(false, true)) {
            return;
        }
        this.logger.info("======================================================");
        this.logger.info("Manage your Hazelcast cluster with the Management Center SaaS Application");
        this.logger.info("To register, copy/paste the following url in your browser and follow the instructions.");
        this.logger.info(this.getHostedManagementCenterUrl() + "/register.jsp");
        this.logger.info("======================================================");
    }

    private String getClusterId() {
        String clusterId = this.managementCenterConfig.getClusterId();
        if (!StringUtil.isNullOrEmpty(clusterId)) {
            return clusterId;
        }
        if (!this.isHostedManagementCenterEnabled()) {
            return null;
        }
        return this.newClusterId();
    }

    private String newClusterId() {
        IAtomicReference<String> clusterIdReference = this.instance.getAtomicReference("___clusterIdGenerator");
        String id = (String)clusterIdReference.get();
        if (id == null && !clusterIdReference.compareAndSet(null, id = UUID.randomUUID().toString().replace("-", ""))) {
            id = (String)clusterIdReference.get();
        }
        return id;
    }

    private ManagementCenterConfig getManagementCenterConfig() {
        ManagementCenterConfig config = this.instance.node.config.getManagementCenterConfig();
        if (config == null) {
            throw new IllegalStateException("ManagementCenterConfig can't be null!");
        }
        return config;
    }

    private ManagementCenterIdentifier newManagementCenterIdentifier() {
        Address address = this.instance.node.address;
        String groupName = this.instance.getConfig().getGroupConfig().getName();
        String version = this.instance.node.getBuildInfo().getVersion();
        return new ManagementCenterIdentifier(version, groupName, address.getHost() + ":" + address.getPort());
    }

    private static String cleanupUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.endsWith("/") ? url : url + '/';
    }

    public void start() {
        if (this.managementCenterUrl == null) {
            this.logger.warning("Can't start Hazelcast Management Center Service: web-server URL is null!");
            return;
        }
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        this.taskPollThread.start();
        this.stateSendThread.start();
        this.logger.info("Hazelcast will connect to Hazelcast Management Center on address: \n" + this.managementCenterUrl);
    }

    public void shutdown() {
        if (!this.isRunning.compareAndSet(true, false)) {
            return;
        }
        this.logger.info("Shutting down Hazelcast Management Center Service");
        try {
            this.interruptThread(this.stateSendThread);
            this.interruptThread(this.taskPollThread);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public byte[] clusterWideUpdateManagementCenterUrl(String groupName, String groupPass, String newUrl) {
        try {
            GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
            if (!groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass)) {
                return HttpCommand.RES_403;
            }
            Collection<MemberImpl> memberList = this.instance.node.clusterService.getMemberList();
            for (MemberImpl member : memberList) {
                this.send(member.getAddress(), new UpdateManagementCenterUrlOperation(newUrl));
            }
            return HttpCommand.RES_204;
        }
        catch (Throwable throwable) {
            this.logger.warning("New Management Center url cannot be assigned.", throwable);
            return HttpCommand.RES_500;
        }
    }

    public void updateManagementCenterUrl(String newUrl) {
        if (newUrl == null) {
            return;
        }
        this.managementCenterUrl = newUrl;
        if (newUrl.equals(this.managementCenterUrl)) {
            return;
        }
        if (!this.isRunning()) {
            this.start();
        }
        this.urlChanged = true;
        this.logger.info("Management Center URL has changed. Hazelcast will connect to Management Center on address: \n" + this.managementCenterUrl);
    }

    private void interruptThread(Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    public void signalVersionMismatch() {
        this.versionMismatch = true;
    }

    public Object callOnAddress(Address address, Operation operation) {
        OperationService operationService = this.instance.node.nodeEngine.getOperationService();
        InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", operation, address);
        try {
            return future.get();
        }
        catch (Throwable t) {
            StringWriter s = new StringWriter();
            t.printStackTrace(new PrintWriter(s));
            return s.toString();
        }
    }

    public Object callOnMember(Member member, Operation operation) {
        Address address = ((MemberImpl)member).getAddress();
        return this.callOnAddress(address, operation);
    }

    public void send(Address address, Operation operation) {
        OperationService operationService = this.instance.node.nodeEngine.getOperationService();
        operationService.createInvocationBuilder("hz:impl:mapService", operation, address).invoke();
    }

    public HazelcastInstanceImpl getHazelcastInstance() {
        return this.instance;
    }

    public ConsoleCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    private boolean isRunning() {
        return this.isRunning.get();
    }

    private void post(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            this.logger.warning("Failed to send response, responseCode:" + responseCode + " url:" + connection.getURL());
        }
    }

    private void sleepOnVersionMismatch() throws InterruptedException {
        if (this.versionMismatch) {
            Thread.sleep(60000L);
            this.versionMismatch = false;
        }
    }

    public class MemberListenerImpl
    implements MembershipListener {
        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
            try {
                Member member = membershipEvent.getMember();
                if (member != null && ((ManagementCenterService)ManagementCenterService.this).instance.node.isMaster() && ManagementCenterService.this.urlChanged) {
                    UpdateManagementCenterUrlOperation operation = new UpdateManagementCenterUrlOperation(ManagementCenterService.this.managementCenterUrl);
                    ManagementCenterService.this.callOnMember(member, operation);
                }
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.warning("Web server url cannot be send to the newly joined member", e);
            }
        }

        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }

    private class LifecycleListenerImpl
    implements LifecycleListener {
        private LifecycleListenerImpl() {
        }

        @Override
        public void stateChanged(LifecycleEvent event) {
            if (event.getState() == LifecycleEvent.LifecycleState.STARTED) {
                try {
                    ManagementCenterService.this.start();
                }
                catch (Exception e) {
                    ManagementCenterService.this.logger.severe("ManagementCenterService could not be started!", e);
                }
            }
        }
    }

    private class TaskPollThread
    extends Thread {
        private final Map<Integer, Class<? extends ConsoleRequest>> consoleRequests;
        private final Random rand;

        TaskPollThread() {
            super(((ManagementCenterService)ManagementCenterService.this).instance.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).instance.node.getThreadNamePrefix("MC.Task.Poller"));
            this.consoleRequests = new HashMap<Integer, Class<? extends ConsoleRequest>>();
            this.rand = new Random();
            this.register(new RuntimeStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
            this.register(new MemberConfigRequest());
            this.register(new ClusterPropsRequest());
            this.register(new GetLogsRequest());
            this.register(new RunGcRequest());
            this.register(new GetMemberSystemPropertiesRequest());
            this.register(new GetMapEntryRequest());
            this.register(new VersionMismatchLogRequest());
            this.register(new ShutdownMemberRequest());
            this.register(new GetSystemWarningsRequest());
        }

        public void register(ConsoleRequest consoleRequest) {
            this.consoleRequests.put(consoleRequest.getType(), consoleRequest.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTaskAndPostResponse(int taskId, ConsoleRequest task) {
            try {
                HttpURLConnection connection = this.openPostResponseConnection();
                OutputStream outputStream = connection.getOutputStream();
                try {
                    ManagementCenterService.this.identifier.write(outputStream);
                    ObjectDataOutputStream out = ManagementCenterService.this.serializationService.createObjectDataOutputStream(outputStream);
                    out.writeInt(taskId);
                    out.writeInt(task.getType());
                    task.writeResponse(ManagementCenterService.this, out);
                    out.flush();
                    ManagementCenterService.this.post(connection);
                }
                finally {
                    IOUtil.closeResource(outputStream);
                }
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.warning("Failed process task:" + task, e);
            }
        }

        private HttpURLConnection openPostResponseConnection() throws IOException {
            URL url = this.newPostResponseUrl();
            if (ManagementCenterService.this.logger.isFinestEnabled()) {
                ManagementCenterService.this.logger.finest("Opening sendResponse connection:" + url);
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return connection;
        }

        private URL newPostResponseUrl() throws MalformedURLException {
            return new URL(ManagementCenterService.cleanupUrl(ManagementCenterService.this.managementCenterUrl) + "putResponse.do");
        }

        @Override
        public void run() {
            try {
                while (ManagementCenterService.this.isRunning()) {
                    ManagementCenterService.this.sleepOnVersionMismatch();
                    this.processTask();
                    this.sleep();
                }
            }
            catch (Throwable throwable) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(throwable);
                ManagementCenterService.this.logger.warning("Problem on Hazelcast Management Center Service while polling for a task.", throwable);
            }
        }

        private void sleep() throws InterruptedException {
            Thread.sleep(700 + this.rand.nextInt(300));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTask() {
            ObjectDataInputStream inputStream = null;
            try {
                inputStream = this.openTaskInputStream();
                int taskId = inputStream.readInt();
                if (taskId <= 0) {
                    return;
                }
                ConsoleRequest task = this.newTask(inputStream);
                this.processTaskAndPostResponse(taskId, task);
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.finest(e);
            }
            finally {
                IOUtil.closeResource(inputStream);
            }
        }

        private ObjectDataInputStream openTaskInputStream() throws IOException {
            URLConnection connection = this.openGetTaskConnection();
            InputStream inputStream = connection.getInputStream();
            return ManagementCenterService.this.serializationService.createObjectDataInputStream(inputStream);
        }

        private ConsoleRequest newTask(ObjectDataInputStream inputStream) throws InstantiationException, IllegalAccessException, IOException {
            int requestType = inputStream.readInt();
            Class<? extends ConsoleRequest> requestClass = this.consoleRequests.get(requestType);
            if (requestClass == null) {
                throw new RuntimeException("Failed to find a request for requestType:" + requestType);
            }
            ConsoleRequest task = requestClass.newInstance();
            task.readData(inputStream);
            return task;
        }

        private URLConnection openGetTaskConnection() throws IOException {
            URL url = this.newGetTaskUrl();
            if (ManagementCenterService.this.logger.isFinestEnabled()) {
                ManagementCenterService.this.logger.finest("Opening getTask connection:" + url);
            }
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Connection", "keep-alive");
            return connection;
        }

        private URL newGetTaskUrl() throws MalformedURLException {
            GroupConfig groupConfig = ManagementCenterService.this.instance.getConfig().getGroupConfig();
            Address localAddress = ((MemberImpl)((ManagementCenterService)ManagementCenterService.this).instance.node.getClusterService().getLocalMember()).getAddress();
            String urlString = ManagementCenterService.cleanupUrl(ManagementCenterService.this.managementCenterUrl) + "getTask.do?member=" + localAddress.getHost() + ":" + localAddress.getPort() + "&cluster=" + groupConfig.getName();
            if (ManagementCenterService.this.clusterId != null) {
                urlString = urlString + "&clusterid=" + ManagementCenterService.this.clusterId;
            }
            if (ManagementCenterService.this.securityToken != null) {
                urlString = urlString + "&securitytoken=" + ManagementCenterService.this.securityToken;
            }
            return new URL(urlString);
        }
    }

    private class StateSendThread
    extends Thread {
        private final TimedMemberStateFactory timedMemberStateFactory;
        private final int updateIntervalMs;

        private StateSendThread() {
            super(ManagementCenterService.this.instance.getThreadGroup(), ((ManagementCenterService)ManagementCenterService.this).instance.node.getThreadNamePrefix("MC.State.Sender"));
            this.timedMemberStateFactory = new TimedMemberStateFactory(ManagementCenterService.this.instance);
            this.updateIntervalMs = this.calcUpdateInterval();
        }

        private int calcUpdateInterval() {
            int updateInterval = ManagementCenterService.this.managementCenterConfig.getUpdateInterval();
            return updateInterval > 0 ? updateInterval * 1000 : 5000;
        }

        @Override
        public void run() {
            try {
                while (ManagementCenterService.this.isRunning()) {
                    ManagementCenterService.this.sleepOnVersionMismatch();
                    this.sendState();
                    this.sleep();
                }
            }
            catch (Throwable throwable) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(throwable);
                ManagementCenterService.this.logger.warning("Hazelcast Management Center Service will be shutdown due to exception.", throwable);
                ManagementCenterService.this.shutdown();
            }
        }

        private void sleep() throws InterruptedException {
            Thread.sleep(this.updateIntervalMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendState() throws InterruptedException, MalformedURLException {
            URL url = this.newCollectorUrl();
            try {
                HttpURLConnection connection = this.openConnection(url);
                OutputStream outputStream = connection.getOutputStream();
                try {
                    ManagementCenterService.this.identifier.write(outputStream);
                    ObjectDataOutputStream out = ManagementCenterService.this.serializationService.createObjectDataOutputStream(outputStream);
                    TimedMemberState timedMemberState = this.timedMemberStateFactory.createTimedMemberState();
                    timedMemberState.writeData(out);
                    outputStream.flush();
                    ManagementCenterService.this.post(connection);
                }
                finally {
                    IOUtil.closeResource(outputStream);
                }
            }
            catch (ConnectException e) {
                if (ManagementCenterService.this.logger.isFinestEnabled()) {
                    ManagementCenterService.this.logger.finest(e);
                } else {
                    ManagementCenterService.this.logger.info("Failed to connect to:" + url);
                }
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.warning(e);
            }
        }

        private HttpURLConnection openConnection(URL url) throws IOException {
            if (ManagementCenterService.this.logger.isFinestEnabled()) {
                ManagementCenterService.this.logger.finest("Opening collector connection:" + url);
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            return connection;
        }

        private URL newCollectorUrl() throws MalformedURLException {
            String url = ManagementCenterService.cleanupUrl(ManagementCenterService.this.managementCenterUrl) + "collector.do";
            if (ManagementCenterService.this.clusterId != null) {
                url = url + "?clusterid=" + ManagementCenterService.this.clusterId;
            }
            if (ManagementCenterService.this.securityToken != null) {
                url = ManagementCenterService.this.clusterId == null ? url + "?securitytoken=" + ManagementCenterService.this.securityToken : url + "&securitytoken=" + ManagementCenterService.this.securityToken;
            }
            return new URL(url);
        }
    }
}

