/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.query.SqlPredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class AllTest {
    private static final int ONE_SECOND = 1000;
    private static final int STATS_SECONDS = 10;
    private static final int SIZE = 10000;
    final Logger logger = Logger.getLogger("All-test");
    final HazelcastInstance hazelcast;
    private volatile boolean running = true;
    private final int nThreads;
    private final List<Runnable> operations = new ArrayList<Runnable>();
    private final ExecutorService ex;
    private final Random random = new Random();
    private final AtomicInteger messagesReceived = new AtomicInteger(0);
    private final AtomicInteger messagesSend = new AtomicInteger(0);

    AllTest(int nThreads) {
        this.nThreads = nThreads;
        this.ex = Executors.newFixedThreadPool(nThreads);
        this.hazelcast = Hazelcast.newHazelcastInstance(null);
        List<Runnable> mapOperations = this.loadMapOperations();
        List<Runnable> qOperations = this.loadQOperations();
        List<Runnable> topicOperations = this.loadTopicOperations();
        this.operations.addAll(mapOperations);
        this.operations.addAll(qOperations);
        this.operations.addAll(topicOperations);
        Collections.shuffle(this.operations);
    }

    public static void main(String[] args) {
        int nThreads = args.length == 0 ? 10 : new Integer(args[0]);
        final AllTest allTest = new AllTest(nThreads);
        allTest.start();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        System.out.println("cluster SIZE:" + allTest.hazelcast.getCluster().getMembers().size());
                        allTest.mapStats();
                        allTest.qStats();
                        allTest.topicStats();
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        });
    }

    private void qStats() {
    }

    private void log(Object message) {
        if (message != null) {
            this.logger.info(message.toString());
        }
    }

    private void mapStats() {
    }

    private void topicStats() {
        this.log("Topic Messages Sent : " + this.messagesSend.getAndSet(0) / 10 + "::: Messages Received: " + this.messagesReceived.getAndSet(0) / 10);
    }

    private void addOperation(List<Runnable> operations, Runnable runnable, int priority) {
        for (int i = 0; i < priority; ++i) {
            operations.add(runnable);
        }
    }

    private void start() {
        for (int i = 0; i < this.nThreads; ++i) {
            this.ex.submit(new Runnable(){

                @Override
                public void run() {
                    while (AllTest.this.running) {
                        int opId = AllTest.this.random.nextInt(AllTest.this.operations.size());
                        Runnable operation = (Runnable)AllTest.this.operations.get(opId);
                        operation.run();
                    }
                }
            });
        }
    }

    private void stop() {
        this.running = false;
    }

    private List<Runnable> loadTopicOperations() {
        ITopic topic = this.hazelcast.getTopic("myTopic");
        topic.addMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AllTest.this.messagesReceived.incrementAndGet();
            }
        });
        ArrayList<Runnable> operations = new ArrayList<Runnable>();
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                ITopic<String> topic = AllTest.this.hazelcast.getTopic("myTopic");
                topic.publish(String.valueOf(AllTest.this.random.nextInt(100000000)));
                AllTest.this.messagesSend.incrementAndGet();
            }
        }, 10);
        return operations;
    }

    private List<Runnable> loadQOperations() {
        ArrayList<Runnable> operations = new ArrayList<Runnable>();
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue<byte[]> q = AllTest.this.hazelcast.getQueue("myQ");
                q.offer(new byte[100]);
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue<byte[]> q = AllTest.this.hazelcast.getQueue("myQ");
                try {
                    q.offer(new byte[100], 10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.contains(new byte[100]);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.isEmpty();
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.size();
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.remove(new byte[100]);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.remainingCapacity();
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                q.poll();
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue<byte[]> q = AllTest.this.hazelcast.getQueue("myQ");
                q.add(new byte[100]);
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                try {
                    q.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                for (int i = 0; i < 10; ++i) {
                    list.add(new byte[100]);
                }
                q.addAll(list);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IQueue q = AllTest.this.hazelcast.getQueue("myQ");
                ArrayList list = new ArrayList();
                q.drainTo(list);
            }
        }, 1);
        return operations;
    }

    private List<Runnable> loadMapOperations() {
        ArrayList<Runnable> operations = new ArrayList<Runnable>();
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.evict(AllTest.this.random.nextInt(10000));
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                try {
                    map.getAsync(AllTest.this.random.nextInt(10000)).get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.containsKey(AllTest.this.random.nextInt(10000));
            }
        }, 2);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.containsValue(new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(100000))));
            }
        }, 2);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                int key = AllTest.this.random.nextInt(10000);
                map.lock(key);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    map.unlock(key);
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                int key;
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                boolean locked = map.tryLock(key = AllTest.this.random.nextInt(10000));
                if (locked) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        map.unlock(key);
                    }
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                int key = AllTest.this.random.nextInt(10000);
                boolean locked = false;
                try {
                    locked = map.tryLock(key, 10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (locked) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        map.unlock(key);
                    }
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.entrySet().iterator();
                for (int i = 0; i < 10 && it.hasNext(); ++i) {
                    it.next();
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.getEntryView(AllTest.this.random.nextInt(10000));
            }
        }, 2);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.isEmpty();
            }
        }, 3);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.put(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
            }
        }, 50);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.tryPut(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))), 10L, TimeUnit.MILLISECONDS);
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                try {
                    map.putAsync(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000)))).get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.put(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))), 10L, TimeUnit.MILLISECONDS);
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.putIfAbsent(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))), 10L, TimeUnit.MILLISECONDS);
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.putIfAbsent(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                HashMap<Integer, Customer> localMap = new HashMap<Integer, Customer>();
                for (int i = 0; i < 10; ++i) {
                    localMap.put(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
                }
                map.putAll(localMap);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.get(AllTest.this.random.nextInt(10000));
            }
        }, 100);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.remove(AllTest.this.random.nextInt(10000));
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.tryRemove(AllTest.this.random.nextInt(10000), 10L, TimeUnit.MILLISECONDS);
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.removeAsync(AllTest.this.random.nextInt(10000));
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.remove(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.replace(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
            }
        }, 4);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap<Integer, Customer> map = AllTest.this.hazelcast.getMap("myMap");
                map.replace(AllTest.this.random.nextInt(10000), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))), new Customer(AllTest.this.random.nextInt(100), String.valueOf(AllTest.this.random.nextInt(10000))));
            }
        }, 5);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.size();
            }
        }, 4);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.entrySet(new SqlPredicate("year=" + AllTest.this.random.nextInt(100))).iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.entrySet(new SqlPredicate("name=" + AllTest.this.random.nextInt(10000))).iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.keySet(new SqlPredicate("name=" + AllTest.this.random.nextInt(10000))).iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.localKeySet().iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                Iterator it = map.localKeySet(new SqlPredicate("name=" + AllTest.this.random.nextInt(10000))).iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }, 10);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                final CountDownLatch latch = new CountDownLatch(1);
                EntryAdapter listener = new EntryAdapter(){

                    public void onEntryEvent(EntryEvent event) {
                        latch.countDown();
                    }
                };
                String id = map.addEntryListener(listener, true);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                map.removeEntryListener(id);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                map.addIndex("year", true);
            }
        }, 1);
        this.addOperation(operations, new Runnable(){

            @Override
            public void run() {
                IMap map = AllTest.this.hazelcast.getMap("myMap");
                final CountDownLatch latch = new CountDownLatch(1);
                EntryAdapter listener = new EntryAdapter(){

                    public void onEntryEvent(EntryEvent event) {
                        latch.countDown();
                    }
                };
                String id = map.addLocalEntryListener(listener);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                map.removeEntryListener(id);
            }
        }, 1);
        return operations;
    }

    public static class Customer
    implements Serializable {
        private int year;
        private String name;
        private byte[] field = new byte[100];

        public Customer(int i, String s) {
            this.year = i;
            this.name = s;
        }
    }
}

