/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.executor.client.CancellationRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

public final class ClientCancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private volatile boolean cancelled;

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target) {
        super(future, context.getSerializationService());
        this.context = context;
        this.uuid = uuid;
        this.target = target;
    }

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target, V defaultValue) {
        super(future, context.getSerializationService(), defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.target = target;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        Future f = this.invokeCancelRequest(mayInterruptIfRunning);
        try {
            Boolean b = (Boolean)this.context.getSerializationService().toObject(f.get());
            if (b != null && b.booleanValue()) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.setDone();
        }
    }

    private Future invokeCancelRequest(boolean mayInterruptIfRunning) {
        CancellationRequest request = new CancellationRequest(this.uuid, this.target, mayInterruptIfRunning);
        try {
            return this.context.getInvocationService().invokeOnTarget(request, this.target);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

