/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public final class ClientInvocationServiceImpl
implements ClientInvocationService {
    private final HazelcastClient client;
    private final ClientConnectionManager connectionManager;
    private final ConcurrentMap<String, Integer> registrationMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, String> registrationAliasMap = new ConcurrentHashMap<String, String>();
    private final Set<ClientCallFuture> failedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public ClientInvocationServiceImpl(HazelcastClient client) {
        this.client = client;
        this.connectionManager = client.getConnectionManager();
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnRandomTarget(ClientRequest request) throws Exception {
        return this.send(request);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnTarget(ClientRequest request, Address target) throws Exception {
        return this.send(request, target);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnKeyOwner(ClientRequest request, Object key) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            return this.invokeOnTarget(request, owner);
        }
        return this.invokeOnRandomTarget(request);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnRandomTarget(ClientRequest request, EventHandler handler) throws Exception {
        return this.sendAndHandle(request, handler);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnTarget(ClientRequest request, Address target, EventHandler handler) throws Exception {
        return this.sendAndHandle(request, target, handler);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnKeyOwner(ClientRequest request, Object key, EventHandler handler) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            return this.invokeOnTarget(request, owner, handler);
        }
        return this.invokeOnRandomTarget(request, handler);
    }

    public ICompletableFuture send(ClientRequest request, ClientConnection connection) throws IOException {
        return this.doSend(request, connection, null);
    }

    public Future reSend(ClientCallFuture future) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        this._send(future, connection);
        return future;
    }

    public void registerFailedListener(ClientCallFuture future) {
        this.failedListeners.add(future);
    }

    public void triggerFailedListeners() {
        Iterator<ClientCallFuture> iterator = this.failedListeners.iterator();
        while (iterator.hasNext()) {
            ClientCallFuture failedListener = iterator.next();
            iterator.remove();
            failedListener.resend();
        }
    }

    public void registerListener(String uuid, Integer callId) {
        this.registrationAliasMap.put(uuid, uuid);
        this.registrationMap.put(uuid, callId);
    }

    public void reRegisterListener(String uuid, String alias, Integer callId) {
        String oldAlias = this.registrationAliasMap.put(uuid, alias);
        if (oldAlias != null) {
            this.registrationMap.remove(oldAlias);
            this.registrationMap.put(alias, callId);
        }
    }

    public boolean isRedoOperation() {
        return this.client.getClientConfig().isRedoOperation();
    }

    public String deRegisterListener(String alias) {
        String uuid = (String)this.registrationAliasMap.remove(alias);
        if (uuid != null) {
            Integer callId = (Integer)this.registrationMap.remove(alias);
            this.connectionManager.removeEventHandler(callId);
        }
        return uuid;
    }

    private ICompletableFuture send(ClientRequest request) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        return this.doSend(request, connection, null);
    }

    private ICompletableFuture send(ClientRequest request, Address target) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(target);
        return this.doSend(request, connection, null);
    }

    private ICompletableFuture sendAndHandle(ClientRequest request, EventHandler handler) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        return this.doSend(request, connection, handler);
    }

    private ICompletableFuture sendAndHandle(ClientRequest request, Address target, EventHandler handler) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(target);
        return this.doSend(request, connection, handler);
    }

    private ICompletableFuture doSend(ClientRequest request, ClientConnection connection, EventHandler handler) {
        ClientCallFuture future = new ClientCallFuture(this.client, request, handler);
        this._send(future, connection);
        return future;
    }

    private void _send(ClientCallFuture future, ClientConnection connection) {
        connection.registerCallId(future);
        future.setConnection(connection);
        SerializationService ss = this.client.getSerializationService();
        Data data = ss.toData(future.getRequest());
        if (!connection.write(new DataAdapter(data))) {
            future.notify(new TargetNotMemberException("Address : " + connection.getRemoteEndpoint()));
            int callId = future.getRequest().getCallId();
            connection.deRegisterCallId(callId);
            connection.deRegisterEventHandler(callId);
        }
    }
}

