/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;

public abstract class PartitionClientRequest
extends ClientRequest {
    private static final int TRY_COUNT = 100;

    protected void beforeProcess() {
    }

    protected void afterResponse() {
    }

    @Override
    final void process() {
        this.beforeProcess();
        ClientEndpoint endpoint = this.getEndpoint();
        Operation op = this.prepareOperation();
        op.setCallerUuid(endpoint.getUuid());
        InvocationBuilder builder = this.clientEngine.createInvocationBuilder(this.getServiceName(), op, this.getPartition()).setReplicaIndex(this.getReplicaIndex()).setTryCount(100).setResultDeserialized(false).setCallback(new CallbackImpl(endpoint));
        builder.invoke();
    }

    protected abstract Operation prepareOperation();

    protected abstract int getPartition();

    protected abstract int getReplicaIndex();

    protected Object filter(Object response) {
        return response;
    }

    private class CallbackImpl
    implements Callback<Object> {
        private final ClientEndpoint endpoint;

        public CallbackImpl(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void notify(Object object) {
            this.endpoint.sendResponse(PartitionClientRequest.this.filter(object), PartitionClientRequest.this.getCallId());
            PartitionClientRequest.this.afterResponse();
        }
    }
}

