/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CompletableFutureTask<V>
extends FutureTask<V>
implements ICompletableFuture<V> {
    private final AtomicReferenceFieldUpdater<CompletableFutureTask, ExecutionCallbackNode> callbackUpdater;
    private final ILogger logger = Logger.getLogger(CompletableFutureTask.class);
    private final ExecutorService asyncExecutor;
    private volatile ExecutionCallbackNode<V> callbackHead;

    public CompletableFutureTask(Callable<V> callable, ExecutorService asyncExecutor) {
        super(callable);
        this.asyncExecutor = asyncExecutor;
        this.callbackUpdater = AtomicReferenceFieldUpdater.newUpdater(CompletableFutureTask.class, ExecutionCallbackNode.class, "callbackHead");
    }

    public CompletableFutureTask(Runnable runnable, V result, ExecutorService asyncExecutor) {
        super(runnable, result);
        this.asyncExecutor = asyncExecutor;
        this.callbackUpdater = AtomicReferenceFieldUpdater.newUpdater(CompletableFutureTask.class, ExecutionCallbackNode.class, "callbackHead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            this.fireCallbacks();
        }
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.asyncExecutor);
    }

    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ExecutionCallbackNode newCallbackHead;
        ExecutionCallbackNode<V> oldCallbackHead;
        ValidationUtil.isNotNull(callback, "callback");
        ValidationUtil.isNotNull(executor, "executor");
        if (this.isDone()) {
            this.runAsynchronous(callback, executor);
            return;
        }
        while (!this.callbackUpdater.compareAndSet(this, oldCallbackHead = this.callbackHead, newCallbackHead = new ExecutionCallbackNode(callback, executor, oldCallbackHead))) {
        }
    }

    private Object readResult() {
        try {
            return this.get();
        }
        catch (Throwable t) {
            return t;
        }
    }

    private void fireCallbacks() {
        ExecutionCallbackNode callbackChain;
        while (!this.callbackUpdater.compareAndSet(this, callbackChain = this.callbackHead, null)) {
        }
        while (callbackChain != null) {
            this.runAsynchronous(callbackChain.callback, callbackChain.executor);
            callbackChain = callbackChain.next;
        }
    }

    private void runAsynchronous(final ExecutionCallback<V> callback, Executor executor) {
        final Object result = this.readResult();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (result instanceof Throwable) {
                        callback.onFailure((Throwable)result);
                    } else {
                        callback.onResponse(result);
                    }
                }
                catch (Throwable t) {
                    CompletableFutureTask.this.logger.severe("Failed to async for " + CompletableFutureTask.this, t);
                }
            }
        });
    }

    private static class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

