/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.impl.BroadcastTxRollbackOperation;
import com.hazelcast.transaction.impl.RecoverTxnOperation;
import com.hazelcast.transaction.impl.RecoveredTransaction;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionContextImpl;
import com.hazelcast.transaction.impl.TransactionImpl;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;

public class TransactionManagerServiceImpl
implements TransactionManagerService,
ManagedService,
MembershipAwareService,
ClientAwareService {
    public static final String SERVICE_NAME = "hz:core:txManagerService";
    public static final int RECOVER_TIMEOUT = 5000;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ConcurrentMap<String, TxBackupLog> txBackupLogs = new ConcurrentHashMap<String, TxBackupLog>();
    private final ConcurrentMap<SerializableXID, Transaction> managedTransactions = new ConcurrentHashMap<SerializableXID, Transaction>();
    private final ConcurrentMap<SerializableXID, RecoveredTransaction> clientRecoveredTransactions = new ConcurrentHashMap<SerializableXID, RecoveredTransaction>();

    public TransactionManagerServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(TransactionManagerService.class);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        if (task == null) {
            throw new NullPointerException("TransactionalTask is required!");
        }
        TransactionContextImpl context = new TransactionContextImpl(this, this.nodeEngine, options, null);
        context.beginTransaction();
        try {
            T value = task.execute(context);
            context.commitTransaction();
            return value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextImpl(this, this.nodeEngine, options, null);
    }

    @Override
    public TransactionContext newClientTransactionContext(TransactionOptions options, String clientUuid) {
        return new TransactionContextImpl(this, this.nodeEngine, options, clientUuid);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.txBackupLogs.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    public void addClientRecoveredTransaction(RecoveredTransaction rt) {
        this.clientRecoveredTransactions.put(rt.getXid(), rt);
    }

    public void recoverClientTransaction(SerializableXID sXid, boolean commit) {
        RecoveredTransaction rt = (RecoveredTransaction)this.clientRecoveredTransactions.remove(sXid);
        if (rt == null) {
            return;
        }
        TransactionImpl tx = new TransactionImpl(this, this.nodeEngine, rt.getTxnId(), rt.getTxLogs(), rt.getTimeoutMillis(), rt.getStartTime(), rt.getCallerUuid());
        if (commit) {
            try {
                tx.commit();
            }
            catch (Throwable e) {
                this.logger.warning("Error during committing recovered client transaction!", e);
            }
        } else {
            try {
                tx.rollback();
            }
            catch (Throwable e) {
                this.logger.warning("Error during rolling-back recovered client transaction!", e);
            }
        }
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        MemberImpl member = event.getMember();
        String uuid = member.getUuid();
        this.finalizeTransactionsOf(uuid);
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public void addManagedTransaction(Xid xid, Transaction transaction) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        ((TransactionImpl)transaction).setXid(sXid);
        this.managedTransactions.put(sXid, transaction);
    }

    public Transaction getManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        return (Transaction)this.managedTransactions.get(sXid);
    }

    public void removeManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        this.managedTransactions.remove(sXid);
    }

    private void finalizeTransactionsOf(String uuid) {
        if (!this.txBackupLogs.isEmpty()) {
            for (Map.Entry entry : this.txBackupLogs.entrySet()) {
                TxBackupLog log = (TxBackupLog)entry.getValue();
                if (!uuid.equals(log.callerUuid)) continue;
                String txnId = (String)entry.getKey();
                if (log.state == Transaction.State.ACTIVE) {
                    Collection<MemberImpl> memberList = this.nodeEngine.getClusterService().getMemberList();
                    ArrayList futures = new ArrayList(memberList.size());
                    for (MemberImpl memberImpl : memberList) {
                        BroadcastTxRollbackOperation op = new BroadcastTxRollbackOperation(txnId);
                        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnTarget(SERVICE_NAME, op, memberImpl.getAddress());
                        futures.add(f);
                    }
                    for (Future future : futures) {
                        try {
                            future.get(TransactionOptions.getDefault().getTimeoutMillis(), TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            this.logger.warning("Error while rolling-back tx!");
                        }
                    }
                    continue;
                }
                if (log.state == Transaction.State.COMMITTING && log.xid != null) {
                    this.logger.warning("This log is XA Managed " + log);
                    log.state = Transaction.State.NO_TXN;
                    continue;
                }
                TransactionImpl tx = new TransactionImpl(this, this.nodeEngine, txnId, log.txLogs, log.timeoutMillis, log.startTime, log.callerUuid);
                if (log.state == Transaction.State.COMMITTING) {
                    try {
                        tx.commit();
                    }
                    catch (Throwable e) {
                        this.logger.warning("Error during committing from tx backup!", e);
                    }
                    continue;
                }
                try {
                    tx.rollback();
                }
                catch (Throwable e) {
                    this.logger.warning("Error during rolling-back from tx backup!", e);
                }
            }
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.finalizeTransactionsOf(clientUuid);
    }

    Address[] pickBackupAddresses(int durability) {
        ClusterService clusterService = this.nodeEngine.getClusterService();
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>(clusterService.getMemberList());
        members.remove(this.nodeEngine.getLocalMember());
        int c = Math.min(members.size(), durability);
        Collections.shuffle(members);
        Address[] addresses = new Address[c];
        for (int i = 0; i < c; ++i) {
            addresses[i] = ((MemberImpl)members.get(i)).getAddress();
        }
        return addresses;
    }

    public void addTxBackupLogForClientRecovery(Transaction transaction) {
        TransactionImpl txnImpl = (TransactionImpl)transaction;
        String callerUuid = txnImpl.getOwnerUuid();
        SerializableXID xid = txnImpl.getXid();
        List<TransactionLog> txLogs = txnImpl.getTxLogs();
        long timeoutMillis = txnImpl.getTimeoutMillis();
        long startTime = txnImpl.getStartTime();
        TxBackupLog log = new TxBackupLog(txLogs, callerUuid, Transaction.State.COMMITTING, timeoutMillis, startTime, xid);
        this.txBackupLogs.put(txnImpl.getTxnId(), log);
    }

    void beginTxBackupLog(String callerUuid, String txnId, SerializableXID xid) {
        TxBackupLog log = new TxBackupLog(Collections.emptyList(), callerUuid, Transaction.State.ACTIVE, -1L, -1L, xid);
        if (this.txBackupLogs.putIfAbsent(txnId, log) != null) {
            throw new TransactionException("TxLog already exists!");
        }
    }

    void prepareTxBackupLog(List<TransactionLog> txLogs, String callerUuid, String txnId, long timeoutMillis, long startTime) {
        TxBackupLog beginLog = (TxBackupLog)this.txBackupLogs.get(txnId);
        if (beginLog == null) {
            throw new TransactionException("Could not find begin tx log!");
        }
        if (beginLog.state != Transaction.State.ACTIVE) {
            throw new TransactionException("TxLog already exists!");
        }
        if (!this.txBackupLogs.replace(txnId, beginLog, new TxBackupLog(txLogs, callerUuid, Transaction.State.COMMITTING, timeoutMillis, startTime, beginLog.xid))) {
            throw new TransactionException("TxLog already exists!");
        }
    }

    void rollbackTxBackupLog(String txnId) {
        TxBackupLog log = (TxBackupLog)this.txBackupLogs.get(txnId);
        if (log != null) {
            log.state = Transaction.State.ROLLING_BACK;
        } else {
            this.logger.warning("No tx backup log is found, tx -> " + txnId);
        }
    }

    void purgeTxBackupLog(String txnId) {
        this.txBackupLogs.remove(txnId);
    }

    public Xid[] recover() {
        OperationService operationService = this.nodeEngine.getOperationService();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(memberList.size() - 1);
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            InternalCompletableFuture internalCompletableFuture = operationService.createInvocationBuilder(SERVICE_NAME, (Operation)new RecoverTxnOperation(), member.getAddress()).invoke();
            futures.add(internalCompletableFuture);
        }
        HashSet<SerializableXID> xidSet = new HashSet<SerializableXID>();
        for (Future future : futures) {
            try {
                SerializableCollection collectionWrapper = (SerializableCollection)future.get(5000L, TimeUnit.MILLISECONDS);
                for (Data data : collectionWrapper) {
                    RecoveredTransaction rt = (RecoveredTransaction)this.nodeEngine.toObject(data);
                    SerializableXID xid = rt.getXid();
                    TransactionImpl tx = new TransactionImpl(this, this.nodeEngine, rt.getTxnId(), rt.getTxLogs(), rt.getTimeoutMillis(), rt.getStartTime(), rt.getCallerUuid());
                    tx.setXid(xid);
                    xidSet.add(xid);
                    this.managedTransactions.put(xid, tx);
                }
            }
            catch (MemberLeftException e) {
                this.logger.warning("Member left while recovering: " + e);
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    Throwable throwable = e = e.getCause() != null ? e.getCause() : e;
                }
                if (e instanceof TargetNotMemberException) {
                    this.nodeEngine.getLogger(Transaction.class).warning("Member left while recovering: " + e);
                    continue;
                }
                throw ExceptionUtil.rethrow(e);
            }
        }
        Set<RecoveredTransaction> localSet = this.recoverLocal();
        for (RecoveredTransaction rt : localSet) {
            xidSet.add(rt.getXid());
        }
        return xidSet.toArray(new Xid[xidSet.size()]);
    }

    public Set<RecoveredTransaction> recoverLocal() {
        HashSet<RecoveredTransaction> recovered = new HashSet<RecoveredTransaction>();
        if (!this.txBackupLogs.isEmpty()) {
            Set entries = this.txBackupLogs.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TxBackupLog log = (TxBackupLog)entry.getValue();
                String txnId = (String)entry.getKey();
                if (log.state != Transaction.State.NO_TXN || log.xid == null) continue;
                RecoveredTransaction rt = new RecoveredTransaction();
                rt.setTxLogs(log.txLogs);
                rt.setXid(log.xid);
                rt.setCallerUuid(log.callerUuid);
                rt.setStartTime(log.startTime);
                rt.setTimeoutMillis(log.timeoutMillis);
                rt.setTxnId(txnId);
                recovered.add(rt);
                iter.remove();
            }
        }
        return recovered;
    }

    private static class TxBackupLog {
        private final List<TransactionLog> txLogs;
        private final String callerUuid;
        private final long timeoutMillis;
        private final long startTime;
        private final SerializableXID xid;
        private volatile Transaction.State state;

        private TxBackupLog(List<TransactionLog> txLogs, String callerUuid, Transaction.State state, long timeoutMillis, long startTime, SerializableXID xid) {
            this.txLogs = txLogs;
            this.callerUuid = callerUuid;
            this.state = state;
            this.timeoutMillis = timeoutMillis;
            this.startTime = startTime;
            this.xid = xid;
        }
    }
}

