/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.QueryException;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.ReflectionHelper;
import java.io.IOException;

public class QueryEntry
implements QueryableEntry {
    private static final PortableExtractor extractor = new PortableExtractor();
    private final SerializationService serializationService;
    private final Data indexKey;
    private Data key;
    private Object keyObject;
    private Data value;
    private Object valueObject;
    private PortableReader reader;

    public QueryEntry(SerializationService serializationService, Data indexKey, Object key, Object value) {
        if (indexKey == null) {
            throw new IllegalArgumentException("index keyData cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.indexKey = indexKey;
        if (key instanceof Data) {
            this.key = (Data)key;
        } else {
            this.keyObject = key;
        }
        this.serializationService = serializationService;
        if (value instanceof Data) {
            this.value = (Data)value;
        } else {
            this.valueObject = value;
        }
    }

    @Override
    public Object getValue() {
        if (this.valueObject == null && this.serializationService != null) {
            this.valueObject = this.serializationService.toObject(this.value);
        }
        return this.valueObject;
    }

    @Override
    public Object getKey() {
        if (this.keyObject == null && this.serializationService != null) {
            this.keyObject = this.serializationService.toObject(this.key);
        }
        return this.keyObject;
    }

    @Override
    public Comparable getAttribute(String attributeName) throws QueryException {
        FieldDefinition fd;
        Data data = this.getValueData();
        if (data != null && data.isPortable() && (fd = data.getClassDefinition().get(attributeName)) != null) {
            PortableReader reader = this.getOrCreatePortableReader();
            return extractor.extract(reader, attributeName, fd.getType().getId());
        }
        return this.extractViaReflection(attributeName);
    }

    private Comparable extractViaReflection(String attributeName) {
        try {
            if ("__key".equals(attributeName)) {
                return (Comparable)this.getKey();
            }
            if ("this".equals(attributeName)) {
                return (Comparable)this.getValue();
            }
            if (attributeName.startsWith("__key")) {
                return ReflectionHelper.extractValue(this, attributeName, this.getKey());
            }
            return ReflectionHelper.extractValue(this, attributeName, this.getValue());
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
    }

    @Override
    public AttributeType getAttributeType(String attributeName) {
        FieldDefinition fd;
        Data data = this.getValueData();
        if (data != null && data.isPortable() && (fd = data.getClassDefinition().get(attributeName)) != null) {
            return AttributeType.getAttributeType(fd.getType().getId());
        }
        return this.getAttributeTypeViaReflection(attributeName);
    }

    private AttributeType getAttributeTypeViaReflection(String attributeName) {
        Class<?> klass;
        if ("__key".equals(attributeName)) {
            klass = this.getKey().getClass();
        } else {
            Object value = this.getValue();
            if ("this".equals(attributeName)) {
                klass = value.getClass();
            } else {
                return ReflectionHelper.getAttributeType(this, attributeName);
            }
        }
        return ReflectionHelper.getAttributeType(klass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntry that = (QueryEntry)o;
        return this.indexKey.equals(that.indexKey);
    }

    @Override
    public int hashCode() {
        return this.indexKey.hashCode();
    }

    @Override
    public Data getKeyData() {
        if (this.key == null && this.serializationService != null) {
            this.key = this.serializationService.toData(this.keyObject);
        }
        return this.key;
    }

    @Override
    public Data getValueData() {
        if (this.value == null && this.serializationService != null) {
            this.value = this.serializationService.toData(this.valueObject);
        }
        return this.value;
    }

    @Override
    public Data getIndexKey() {
        return this.indexKey;
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private PortableReader getOrCreatePortableReader() {
        if (this.reader != null) {
            return this.reader;
        }
        this.reader = this.serializationService.createPortableReader(this.value);
        return this.reader;
    }

    private static class PortableExtractor {
        PortableFieldExtractor[] extractors = new PortableFieldExtractor[FieldType.values().length];

        PortableExtractor() {
            this.extractors[FieldType.BYTE.getId()] = new PortableByteFieldExtractor();
            this.extractors[FieldType.BOOLEAN.getId()] = new PortableBooleanFieldExtractor();
            this.extractors[FieldType.LONG.getId()] = new PortableLongFieldExtractor();
            this.extractors[FieldType.INT.getId()] = new PortableIntegerFieldExtractor();
            this.extractors[FieldType.CHAR.getId()] = new PortableCharFieldExtractor();
            this.extractors[FieldType.DOUBLE.getId()] = new PortableDoubleFieldExtractor();
            this.extractors[FieldType.SHORT.getId()] = new PortableShortFieldExtractor();
            this.extractors[FieldType.FLOAT.getId()] = new PortableFloatFieldExtractor();
            this.extractors[FieldType.UTF.getId()] = new PortableUtfFieldExtractor();
        }

        public Comparable extract(PortableReader reader, String fieldName, byte fieldType) throws QueryException {
            try {
                return this.extractors[fieldType].extract(reader, fieldName);
            }
            catch (IOException e) {
                throw new QueryException(e);
            }
        }

        static interface PortableFieldExtractor {
            public Comparable extract(PortableReader var1, String var2) throws IOException;
        }

        static class PortableBooleanFieldExtractor
        implements PortableFieldExtractor {
            PortableBooleanFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Boolean.valueOf(reader.readBoolean(fieldName));
            }
        }

        static class PortableCharFieldExtractor
        implements PortableFieldExtractor {
            PortableCharFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Character.valueOf(reader.readChar(fieldName));
            }
        }

        static class PortableUtfFieldExtractor
        implements PortableFieldExtractor {
            PortableUtfFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return reader.readUTF(fieldName);
            }
        }

        static class PortableShortFieldExtractor
        implements PortableFieldExtractor {
            PortableShortFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Short.valueOf(reader.readShort(fieldName));
            }
        }

        static class PortableFloatFieldExtractor
        implements PortableFieldExtractor {
            PortableFloatFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Float.valueOf(reader.readFloat(fieldName));
            }
        }

        static class PortableDoubleFieldExtractor
        implements PortableFieldExtractor {
            PortableDoubleFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Double.valueOf(reader.readDouble(fieldName));
            }
        }

        static class PortableLongFieldExtractor
        implements PortableFieldExtractor {
            PortableLongFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Long.valueOf(reader.readLong(fieldName));
            }
        }

        static class PortableByteFieldExtractor
        implements PortableFieldExtractor {
            PortableByteFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Byte.valueOf(reader.readByte(fieldName));
            }
        }

        static class PortableIntegerFieldExtractor
        implements PortableFieldExtractor {
            PortableIntegerFieldExtractor() {
            }

            @Override
            public Comparable extract(PortableReader reader, String fieldName) throws IOException {
                return Integer.valueOf(reader.readInt(fieldName));
            }
        }
    }
}

