/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.task;

import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.impl.task.JobPartitionStateImpl;
import com.hazelcast.mapreduce.impl.task.JobSupervisor;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ValidationUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class JobProcessInformationImpl
implements JobProcessInformation {
    private final AtomicReferenceFieldUpdater<JobProcessInformationImpl, JobPartitionState[]> updater;
    private final AtomicInteger processedRecords = new AtomicInteger();
    private final JobSupervisor supervisor;
    private volatile JobPartitionState[] partitionStates;

    public JobProcessInformationImpl(int partitionCount, JobSupervisor supervisor) {
        this.supervisor = supervisor;
        this.partitionStates = new JobPartitionState[partitionCount];
        this.updater = AtomicReferenceFieldUpdater.newUpdater(JobProcessInformationImpl.class, JobPartitionState[].class, "partitionStates");
    }

    @Override
    public JobPartitionState[] getPartitionStates() {
        return this.partitionStates;
    }

    @Override
    public int getProcessedRecords() {
        return this.processedRecords.get();
    }

    public void addProcessedRecords(int records) {
        this.processedRecords.addAndGet(records);
    }

    public void cancelPartitionState() {
        JobPartitionState[] oldPartitionStates = this.partitionStates;
        JobPartitionState[] newPartitionStates = new JobPartitionState[oldPartitionStates.length];
        for (int i = 0; i < newPartitionStates.length; ++i) {
            Address owner = oldPartitionStates[i] != null ? oldPartitionStates[i].getOwner() : null;
            newPartitionStates[i] = new JobPartitionStateImpl(owner, JobPartitionState.State.CANCELLED);
        }
        this.partitionStates = newPartitionStates;
    }

    public void resetPartitionState() {
        JobPartitionState[] oldPartitionStates = this.partitionStates;
        JobPartitionState[] newPartitionStates = new JobPartitionState[oldPartitionStates.length];
        for (int i = 0; i < newPartitionStates.length; ++i) {
            newPartitionStates[i] = null;
        }
        this.partitionStates = newPartitionStates;
    }

    public boolean updatePartitionState(int partitionId, JobPartitionState oldPartitionState, JobPartitionState newPartitionState) {
        JobPartitionState[] newPartitionStates;
        JobPartitionState[] oldPartitionStates;
        ValidationUtil.isNotNull(newPartitionState, "newPartitionState");
        do {
            if ((oldPartitionStates = this.getPartitionStates())[partitionId] != oldPartitionState) {
                return false;
            }
            newPartitionStates = Arrays.copyOf(oldPartitionStates, oldPartitionStates.length);
            newPartitionStates[partitionId] = newPartitionState;
        } while (!this.updatePartitionState(oldPartitionStates, newPartitionStates));
        return true;
    }

    public boolean updatePartitionState(JobPartitionState[] oldPartitionStates, JobPartitionState[] newPartitionStates) {
        ValidationUtil.isNotNull(newPartitionStates, "newPartitionStates");
        if (oldPartitionStates.length != newPartitionStates.length) {
            throw new IllegalArgumentException("partitionStates need to have same length");
        }
        if (this.updater.compareAndSet(this, oldPartitionStates, newPartitionStates)) {
            this.supervisor.checkFullyProcessed(this);
            return true;
        }
        return false;
    }

    public String toString() {
        return "JobProcessInformationImpl{processedRecords=" + this.processedRecords + ", partitionStates=" + Arrays.toString(this.partitionStates) + '}';
    }
}

