/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.SecureRequest;
import com.hazelcast.client.txn.BaseTransactionRequest;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTxnMapRequest
extends BaseTransactionRequest
implements SecureRequest {
    String name;
    TxnMapRequestType requestType;
    Data key;
    Data value;
    Data newValue;
    long ttl = -1L;

    public AbstractTxnMapRequest() {
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType) {
        this.name = name;
        this.requestType = requestType;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key) {
        this(name, requestType);
        this.key = key;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value) {
        this(name, requestType, key);
        this.value = value;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value, Data newValue) {
        this(name, requestType, key, value);
        this.newValue = newValue;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value, long ttl, TimeUnit timeUnit) {
        this(name, requestType, key, value);
        this.ttl = timeUnit == null ? ttl : timeUnit.toMillis(ttl);
    }

    @Override
    public Object innerCall() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext(this.txnId);
        TransactionalMap<Data, Data> map = context.getMap(this.name);
        switch (this.requestType) {
            case CONTAINS_KEY: {
                return map.containsKey(this.key);
            }
            case GET: {
                return map.get(this.key);
            }
            case GET_FOR_UPDATE: {
                return map.getForUpdate(this.key);
            }
            case SIZE: {
                return map.size();
            }
            case PUT: {
                return map.put(this.key, this.value);
            }
            case PUT_WITH_TTL: {
                return map.put(this.key, this.value, this.ttl, TimeUnit.MILLISECONDS);
            }
            case PUT_IF_ABSENT: {
                return map.putIfAbsent(this.key, this.value);
            }
            case REPLACE: {
                return map.replace(this.key, this.value);
            }
            case REPLACE_IF_SAME: {
                return map.replace(this.key, this.value, this.newValue);
            }
            case SET: {
                map.set(this.key, this.value);
                break;
            }
            case REMOVE: {
                return map.remove(this.key);
            }
            case DELETE: {
                map.delete(this.key);
                break;
            }
            case REMOVE_IF_SAME: {
                return map.remove(this.key, this.value);
            }
            case KEYSET: {
                return this.getMapKeySet(map.keySet());
            }
            case KEYSET_BY_PREDICATE: {
                return this.getMapKeySet(map.keySet(this.getPredicate()));
            }
            case VALUES: {
                return this.getMapValueCollection(map.values());
            }
            case VALUES_BY_PREDICATE: {
                return this.getMapValueCollection(map.values(this.getPredicate()));
            }
        }
        return null;
    }

    private MapKeySet getMapKeySet(Set keySet) {
        HashSet<Data> dataKeySet = new HashSet<Data>();
        for (Object key : keySet) {
            Data dataKey = this.getClientEngine().toData(key);
            dataKeySet.add(dataKey);
        }
        return new MapKeySet(dataKeySet);
    }

    private MapValueCollection getMapValueCollection(Collection coll) {
        HashSet<Data> valuesCollection = new HashSet<Data>(coll.size());
        for (Object value : coll) {
            Data dataValue = this.getClientEngine().toData(value);
            valuesCollection.add(dataValue);
        }
        return new MapValueCollection(valuesCollection);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeInt("t", this.requestType.type);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
        IOUtil.writeNullableData(out, this.newValue);
        this.writeDataInner(out);
        out.writeLong(this.ttl);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.requestType = TxnMapRequestType.getByType(reader.readInt("t"));
        ObjectDataInput in = reader.getRawDataInput();
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
        this.newValue = IOUtil.readNullableData(in);
        this.readDataInner(in);
        this.ttl = in.readLong();
    }

    protected abstract Predicate getPredicate();

    protected abstract void writeDataInner(ObjectDataOutput var1) throws IOException;

    protected abstract void readDataInner(ObjectDataInput var1) throws IOException;

    @Override
    public Permission getRequiredPermission() {
        String action = "read";
        switch (this.requestType) {
            case PUT: 
            case PUT_WITH_TTL: 
            case PUT_IF_ABSENT: 
            case REPLACE: 
            case REPLACE_IF_SAME: 
            case SET: {
                action = "put";
                break;
            }
            case REMOVE: 
            case DELETE: 
            case REMOVE_IF_SAME: {
                action = "remove";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid request type: " + (Object)((Object)this.requestType));
            }
        }
        return new MapPermission(this.name, action);
    }

    public static enum TxnMapRequestType {
        CONTAINS_KEY(1),
        GET(2),
        SIZE(3),
        PUT(4),
        PUT_IF_ABSENT(5),
        REPLACE(6),
        REPLACE_IF_SAME(7),
        SET(8),
        REMOVE(9),
        DELETE(10),
        REMOVE_IF_SAME(11),
        KEYSET(12),
        KEYSET_BY_PREDICATE(13),
        VALUES(14),
        VALUES_BY_PREDICATE(15),
        GET_FOR_UPDATE(16),
        PUT_WITH_TTL(17);

        int type;

        private TxnMapRequestType(int i) {
            this.type = i;
        }

        public static TxnMapRequestType getByType(int type) {
            for (TxnMapRequestType requestType : TxnMapRequestType.values()) {
                if (requestType.type != type) continue;
                return requestType;
            }
            return null;
        }
    }
}

