/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.PartitionServiceImpl;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClusterPropsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 9;
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String[] temp = in.readUTF().split(":#");
            properties.put(temp[0], temp.length == 1 ? "" : temp[1]);
        }
        return properties;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        PartitionServiceImpl partitionService = mcs.getHazelcastInstance().node.getPartitionService();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("hazelcast.cl_version", mcs.getHazelcastInstance().node.getBuildInfo().getVersion());
        properties.put("date.cl_startTime", Long.toString(runtimeMxBean.getStartTime()));
        properties.put("seconds.cl_upTime", Long.toString(runtimeMxBean.getUptime()));
        properties.put("memory.cl_freeMemory", Long.toString(runtime.freeMemory()));
        properties.put("memory.cl_totalMemory", Long.toString(runtime.totalMemory()));
        properties.put("memory.cl_maxMemory", Long.toString(runtime.maxMemory()));
        properties.put("return.hasOngoingMigration", Boolean.toString(partitionService.hasOnGoingMigration()));
        properties.put("data.cl_migrationTasksCount", Long.toString(partitionService.getMigrationQueueSize()));
        dos.writeInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            dos.writeUTF((String)entry.getKey() + ":#" + (String)entry.getValue());
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

