/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.atomic.AtomicReference;

public final class OutOfMemoryErrorDispatcher {
    private static final int MAX_REGISTERED_INSTANCES = 50;
    private static final HazelcastInstance[] EMPTY_INSTANCES = new HazelcastInstance[0];
    private static final AtomicReference<HazelcastInstance[]> instancesRef = new AtomicReference<HazelcastInstance[]>(EMPTY_INSTANCES);
    private static volatile OutOfMemoryHandler handler = new DefaultOutOfMemoryHandler();

    static HazelcastInstance[] current() {
        return instancesRef.get();
    }

    public static void setHandler(OutOfMemoryHandler outOfMemoryHandler) {
        handler = outOfMemoryHandler;
    }

    static void register(HazelcastInstance instance) {
        HazelcastInstance[] newInstances;
        HazelcastInstance[] oldInstances;
        ValidationUtil.isNotNull(instance, "instance");
        do {
            if ((oldInstances = instancesRef.get()).length == 50) {
                return;
            }
            newInstances = new HazelcastInstance[oldInstances.length + 1];
            System.arraycopy(oldInstances, 0, newInstances, 0, oldInstances.length);
            newInstances[oldInstances.length] = instance;
        } while (!instancesRef.compareAndSet(oldInstances, newInstances));
    }

    static void deregister(HazelcastInstance instance) {
        HazelcastInstance[] newInstances;
        HazelcastInstance[] oldInstances;
        ValidationUtil.isNotNull(instance, "instance");
        do {
            int indexOf;
            if ((indexOf = OutOfMemoryErrorDispatcher.indexOf(oldInstances = instancesRef.get(), instance)) == -1) {
                return;
            }
            if (oldInstances.length == 1) {
                newInstances = EMPTY_INSTANCES;
                continue;
            }
            newInstances = new HazelcastInstance[oldInstances.length - 1];
            System.arraycopy(oldInstances, 0, newInstances, 0, indexOf);
            if (indexOf >= newInstances.length) continue;
            System.arraycopy(oldInstances, indexOf + 1, newInstances, indexOf, newInstances.length - indexOf);
        } while (!instancesRef.compareAndSet(oldInstances, newInstances));
    }

    private static int indexOf(HazelcastInstance[] instances, HazelcastInstance instance) {
        for (int k = 0; k < instances.length; ++k) {
            if (instance != instances[k]) continue;
            return k;
        }
        return -1;
    }

    static void clear() {
        instancesRef.set(EMPTY_INSTANCES);
    }

    public static void inspectOutputMemoryError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)throwable);
        }
    }

    public static void onOutOfMemory(OutOfMemoryError outOfMemoryError) {
        ValidationUtil.isNotNull(outOfMemoryError, "outOfMemoryError");
        OutOfMemoryHandler h = handler;
        if (h == null) {
            return;
        }
        HazelcastInstance[] instances = OutOfMemoryErrorDispatcher.removeRegisteredInstances();
        if (instances.length == 0) {
            return;
        }
        try {
            h.onOutOfMemory(outOfMemoryError, instances);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static HazelcastInstance[] removeRegisteredInstances() {
        HazelcastInstance[] instances;
        while (!instancesRef.compareAndSet(instances = instancesRef.get(), EMPTY_INSTANCES)) {
        }
        return instances;
    }

    private OutOfMemoryErrorDispatcher() {
    }

    public static final class Helper {
        private Helper() {
        }

        public static void tryCloseConnections(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            Helper.closeSockets(factory);
        }

        private static void closeSockets(HazelcastInstanceImpl factory) {
            if (factory.node.connectionManager != null) {
                try {
                    factory.node.connectionManager.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public static void tryShutdown(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            Helper.closeSockets(factory);
            try {
                factory.node.shutdown(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static void inactivate(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            factory.node.inactivate();
        }

        public static void tryStopThreads(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            try {
                factory.node.threadGroup.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class DefaultOutOfMemoryHandler
    extends OutOfMemoryHandler {
        private DefaultOutOfMemoryHandler() {
        }

        @Override
        public void onOutOfMemory(OutOfMemoryError oom, HazelcastInstance[] hazelcastInstances) {
            for (HazelcastInstance instance : hazelcastInstances) {
                Helper.tryCloseConnections(instance);
                Helper.tryStopThreads(instance);
                Helper.tryShutdown(instance);
            }
            System.err.println(oom);
        }
    }
}

