/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.operation.MapOperationType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MemberAttributeEvent
extends MembershipEvent
implements DataSerializable {
    private MapOperationType operationType;
    private String key;
    private Object value;
    private Member member;

    public MemberAttributeEvent() {
        super(null, null, 5, null);
    }

    public MemberAttributeEvent(Cluster cluster, MemberImpl member, MapOperationType operationType, String key, Object value) {
        super(cluster, member, 5, null);
        this.member = member;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public MapOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.key);
        this.member.writeData(out);
        switch (this.operationType) {
            case PUT: {
                out.writeByte(2);
                IOUtil.writeAttributeValue(this.value, out);
                break;
            }
            case REMOVE: {
                out.writeByte(3);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation type: " + (Object)((Object)this.operationType));
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readUTF();
        this.member = new MemberImpl();
        this.member.readData(in);
        byte operation = in.readByte();
        switch (operation) {
            case 2: {
                this.operationType = MapOperationType.PUT;
                this.value = IOUtil.readAttributeValue(in);
                break;
            }
            case 3: {
                this.operationType = MapOperationType.REMOVE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation type received: " + (Object)((Object)this.operationType));
            }
        }
        this.source = this.member;
    }
}

