/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.map.operation.MapOperationType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MemberAttributeChange
implements DataSerializable {
    private String uuid;
    private MapOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeChange() {
    }

    public MemberAttributeChange(String uuid, MapOperationType operationType, String key, Object value) {
        this.uuid = uuid;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public String getUuid() {
        return this.uuid;
    }

    public MapOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.uuid);
        out.writeUTF(this.key);
        switch (this.operationType) {
            case PUT: {
                out.writeByte(2);
                IOUtil.writeAttributeValue(this.value, out);
                break;
            }
            case REMOVE: {
                out.writeByte(3);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = in.readUTF();
        this.key = in.readUTF();
        byte operation = in.readByte();
        switch (operation) {
            case 2: {
                this.operationType = MapOperationType.PUT;
                this.value = IOUtil.readAttributeValue(in);
                break;
            }
            case 3: {
                this.operationType = MapOperationType.REMOVE;
            }
        }
    }
}

