/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.DistributedObjectInfo;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import java.util.ArrayList;
import java.util.Collection;

public class GetDistributedObjectsRequest
extends ClientRequest
implements Portable {
    @Override
    void process() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        Collection<DistributedObject> distributedObjects = this.clientEngine.getProxyService().getAllDistributedObjects();
        SerializationService serializationService = this.getClientEngine().getSerializationService();
        ArrayList<Data> dataArrayList = new ArrayList<Data>(distributedObjects.size());
        for (DistributedObject distributedObject : distributedObjects) {
            DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName());
            dataArrayList.add(serializationService.toData(distributedObjectInfo));
        }
        SerializableCollection collection = new SerializableCollection(dataArrayList);
        endpoint.sendResponse(collection, this.getCallId());
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }
}

