/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.rest;

import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.rest.HttpCommand;
import com.hazelcast.ascii.rest.HttpCommandProcessor;
import com.hazelcast.ascii.rest.HttpGetCommand;
import com.hazelcast.ascii.rest.RestValue;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.util.StringUtil;

public class HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    public HttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpGetCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
            String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
            String key = uri.substring(indexEnd + 1);
            Object value = this.textCommandService.get(mapName, key);
            this.prepareResponse(command, value);
        } else if (uri.startsWith("/hazelcast/rest/queues/")) {
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/queues/".length());
            String queueName = uri.substring("/hazelcast/rest/queues/".length(), indexEnd);
            String secondStr = uri.length() > indexEnd + 1 ? uri.substring(indexEnd + 1) : null;
            int seconds = secondStr == null ? 0 : Integer.parseInt(secondStr);
            Object value = this.textCommandService.poll(queueName, seconds);
            this.prepareResponse(command, value);
        } else if (uri.startsWith("/hazelcast/rest/cluster")) {
            Node node = this.textCommandService.getNode();
            StringBuilder res = new StringBuilder(node.getClusterService().membersString());
            res.append("\n");
            ConnectionManager connectionManager = node.getConnectionManager();
            res.append("ConnectionCount: ").append(connectionManager.getCurrentClientConnections());
            res.append("\n");
            res.append("AllConnectionCount: ").append(connectionManager.getAllTextConnections());
            res.append("\n");
            command.setResponse(null, StringUtil.stringToBytes(res.toString()));
        } else if (uri.startsWith("/hazelcast/rest/dump")) {
            String stateDump = this.textCommandService.getNode().getSystemLogService().dump();
            stateDump = stateDump + this.textCommandService.getNode().getPartitionService().toString() + "\n";
            command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, StringUtil.stringToBytes(stateDump));
        } else {
            command.send400();
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpGetCommand command) {
        this.handle(command);
    }

    private void prepareResponse(HttpGetCommand command, Object value) {
        if (value == null) {
            command.send204();
        } else if (value instanceof byte[]) {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, (byte[])value);
        } else if (value instanceof RestValue) {
            RestValue restValue = (RestValue)value;
            command.setResponse(restValue.getContentType(), restValue.getValue());
        } else if (value instanceof String) {
            command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, StringUtil.stringToBytes((String)value));
        } else {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, this.textCommandService.toByteArray(value));
        }
    }
}

