/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;

public class PartitionTableView {
    private final Address[][] addresses;
    private final int version;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PartitionTableView(Address[][] addresses, int version) {
        this.addresses = addresses;
        this.version = version;
    }

    public PartitionTableView(InternalPartition[] partitions, int version) {
        Address[][] a = new Address[partitions.length][7];
        for (InternalPartition partition : partitions) {
            int partitionId = partition.getPartitionId();
            for (int replica = 0; replica < 7; ++replica) {
                a[partitionId][replica] = partition.getReplicaAddress(replica);
            }
        }
        this.addresses = a;
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Address getAddress(int partitionId, int replicaIndex) {
        return this.addresses[partitionId][replicaIndex];
    }

    public int getLength() {
        return this.addresses.length;
    }

    public Address[] getAddresses(int partitionId) {
        Address[] a = this.addresses[partitionId];
        return Arrays.copyOf(a, a.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionTableView that = (PartitionTableView)o;
        return this.version == that.version && Arrays.deepEquals((Object[])this.addresses, (Object[])that.addresses);
    }

    public int hashCode() {
        int result = Arrays.deepHashCode((Object[])this.addresses);
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "PartitionTable{addresses=" + Arrays.deepToString((Object[])this.addresses) + ", version=" + this.version + '}';
    }

    public static void writeData(PartitionTableView table, ObjectDataOutput out) throws IOException {
        Address[][] addresses = table.addresses;
        out.writeInt(addresses.length);
        for (Address[] a : addresses) {
            for (int j = 0; j < 7; ++j) {
                Address address = a[j];
                boolean addressExists = address != null;
                out.writeBoolean(addressExists);
                if (!addressExists) continue;
                address.writeData(out);
            }
        }
        out.writeInt(table.version);
    }

    public static PartitionTableView readData(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        Address[][] addresses = new Address[len][7];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < 7; ++j) {
                Address address;
                boolean exists = in.readBoolean();
                if (!exists) continue;
                addresses[i][j] = address = new Address();
                address.readData(in);
            }
        }
        int version = in.readInt();
        return new PartitionTableView(addresses, version);
    }
}

