/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.statistics;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientStatisticsCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ClientType;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.metrics.Gauge;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Statistics {
    public static final HazelcastProperty ENABLED = new HazelcastProperty("hazelcast.client.statistics.enabled", false);
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.client.statistics.period.seconds", 3, TimeUnit.SECONDS);
    private static final String NEAR_CACHE_CATEGORY_PREFIX = "nc.";
    private static final String FEATURE_SUPPORTED_SINCE_VERSION_STRING = "3.9";
    private static final int FEATURE_SUPPORTED_SINCE_VERSION = BuildInfo.calculateVersion("3.9");
    private static final char STAT_SEPARATOR = ',';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final char ESCAPE_CHAR = '\\';
    private final MetricsRegistry metricsRegistry;
    private final boolean enabled;
    private final HazelcastProperties properties;
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final HazelcastClientInstanceImpl client;
    private final boolean enterprise;
    private PeriodicStatistics periodicStats;
    private volatile Address ownerAddress;

    public Statistics(HazelcastClientInstanceImpl clientInstance) {
        this.properties = clientInstance.getProperties();
        this.enabled = this.properties.getBoolean(ENABLED);
        this.client = clientInstance;
        this.enterprise = BuildInfoProvider.getBuildInfo().isEnterprise();
        this.metricsRegistry = clientInstance.getMetricsRegistry();
    }

    public final void start() {
        if (!this.enabled) {
            return;
        }
        long periodSeconds = this.properties.getSeconds(PERIOD_SECONDS);
        if (periodSeconds <= 0L) {
            long defaultValue = Long.parseLong(PERIOD_SECONDS.getDefaultValue());
            this.logger.warning("Provided client statistics " + PERIOD_SECONDS.getName() + " can not be less than or equal to 0. You provided " + periodSeconds + " seconds as the configuration. Client will use the default value of " + defaultValue + " instead.");
            periodSeconds = defaultValue;
        }
        this.periodicStats = new PeriodicStatistics();
        this.schedulePeriodicStatisticsSendTask(periodSeconds);
        this.logger.info("Client statistics is enabled with period " + periodSeconds + " seconds.");
    }

    private ClientConnection getOwnerConnection() {
        ClientConnection connection = this.client.getConnectionManager().getOwnerConnection();
        if (null == connection) {
            return null;
        }
        Address ownerConnectionAddress = this.client.getConnectionManager().getOwnerConnectionAddress();
        int serverVersion = connection.getConnectedServerVersion();
        if (serverVersion < FEATURE_SUPPORTED_SINCE_VERSION) {
            if ((this.ownerAddress == null || !ownerConnectionAddress.equals(this.ownerAddress)) && this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Client statistics can not be sent to server " + ownerConnectionAddress + " since, connected owner server version is less than the minimum supported server version %s", FEATURE_SUPPORTED_SINCE_VERSION_STRING));
            }
            this.ownerAddress = ownerConnectionAddress;
            return null;
        }
        return connection;
    }

    private void schedulePeriodicStatisticsSendTask(long periodSeconds) {
        this.client.getClientExecutionService().scheduleWithRepetition(new Runnable(){

            @Override
            public void run() {
                ClientConnection ownerConnection = Statistics.this.getOwnerConnection();
                if (null == ownerConnection) {
                    Statistics.this.logger.finest("Can not send client statistics to the server. No owner connection.");
                    return;
                }
                StringBuilder stats = new StringBuilder();
                Statistics.this.periodicStats.fillMetrics(stats, ownerConnection);
                Statistics.this.addNearCacheStats(stats);
                Statistics.this.sendStats(stats.toString(), ownerConnection);
            }
        }, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    private void addNearCacheStats(StringBuilder stats) {
        for (NearCache nearCache : this.client.getNearCacheManager().listAllNearCaches()) {
            String nearCacheName = nearCache.getName();
            StringBuilder nearCacheNameWithPrefix = this.getNameWithPrefix(nearCacheName);
            nearCacheNameWithPrefix.append('.');
            NearCacheStatsImpl nearCacheStats = (NearCacheStatsImpl)nearCache.getNearCacheStats();
            String prefix = nearCacheNameWithPrefix.toString();
            this.addStat(stats, prefix, "creationTime", nearCacheStats.getCreationTime());
            this.addStat(stats, prefix, "evictions", nearCacheStats.getEvictions());
            this.addStat(stats, prefix, "hits", nearCacheStats.getHits());
            this.addStat(stats, prefix, "lastPersistenceDuration", nearCacheStats.getLastPersistenceDuration());
            this.addStat(stats, prefix, "lastPersistenceKeyCount", nearCacheStats.getLastPersistenceKeyCount());
            this.addStat(stats, prefix, "lastPersistenceTime", nearCacheStats.getLastPersistenceTime());
            this.addStat(stats, prefix, "lastPersistenceWrittenBytes", nearCacheStats.getLastPersistenceWrittenBytes());
            this.addStat(stats, prefix, "misses", nearCacheStats.getMisses());
            this.addStat(stats, prefix, "ownedEntryCount", nearCacheStats.getOwnedEntryCount());
            this.addStat(stats, prefix, "expirations", nearCacheStats.getExpirations());
            this.addStat(stats, prefix, "invalidations", nearCacheStats.getInvalidations());
            this.addStat(stats, prefix, "invalidationRequests", nearCacheStats.getInvalidationRequests());
            this.addStat(stats, prefix, "ownedEntryMemoryCost", nearCacheStats.getOwnedEntryMemoryCost());
            String persistenceFailure = nearCacheStats.getLastPersistenceFailure();
            if (persistenceFailure == null || persistenceFailure.isEmpty()) continue;
            this.addStat(stats, prefix, "lastPersistenceFailure", persistenceFailure);
        }
    }

    private void addStat(StringBuilder stats, String name, long value) {
        this.addStat(stats, null, name, value);
    }

    private void addStat(StringBuilder stats, String keyPrefix, String name, long value) {
        stats.append(',');
        if (null != keyPrefix) {
            stats.append(keyPrefix);
        }
        stats.append(name).append('=').append(value);
    }

    private void addStat(StringBuilder stats, String name, String value) {
        this.addStat(stats, null, name, value);
    }

    private void addStat(StringBuilder stats, String keyPrefix, String name, String value) {
        stats.append(',');
        if (null != keyPrefix) {
            stats.append(keyPrefix);
        }
        stats.append(name).append('=').append(value);
    }

    private void addStat(StringBuilder stats, String name, boolean value) {
        stats.append(',').append(name).append('=').append(value);
    }

    private StringBuilder getNameWithPrefix(String name) {
        StringBuilder escapedName = new StringBuilder(NEAR_CACHE_CATEGORY_PREFIX);
        int prefixLen = NEAR_CACHE_CATEGORY_PREFIX.length();
        escapedName.append(name);
        if (escapedName.charAt(prefixLen) == '/') {
            escapedName.deleteCharAt(prefixLen);
        }
        Statistics.escapeSpecialCharacters(escapedName, prefixLen);
        return escapedName;
    }

    public static void escapeSpecialCharacters(StringBuilder buffer) {
        Statistics.escapeSpecialCharacters(buffer, 0);
    }

    public static void escapeSpecialCharacters(StringBuilder buffer, int start) {
        for (int i = start; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c != '=' && c != '.' && c != ',' && c != '\\') continue;
            buffer.insert(i, '\\');
            ++i;
        }
    }

    public static String unescapeSpecialCharacters(String buffer) {
        return Statistics.unescapeSpecialCharacters(buffer, 0);
    }

    public static String unescapeSpecialCharacters(String buffer, int start) {
        StringBuilder result = new StringBuilder(buffer);
        Statistics.unescapeSpecialCharacters(result, start);
        return result.toString();
    }

    public static void unescapeSpecialCharacters(StringBuilder buffer, int start) {
        for (int i = start; i < buffer.length() - 1; ++i) {
            char c = buffer.charAt(i);
            if (c != '\\') continue;
            buffer.deleteCharAt(i);
        }
    }

    public static List<String> split(String statString) {
        return Statistics.split(statString, 0, ',');
    }

    public static List<String> split(String stat, int start, char splitChar) {
        int index;
        int bufferLen = stat.length();
        if (bufferLen == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int strStart = start;
        int previousChar = 97;
        for (index = start; index < bufferLen; ++index) {
            char currentChar = stat.charAt(index);
            if (currentChar == splitChar && previousChar != 92) {
                result.add(stat.substring(strStart, index));
                strStart = index + 1;
            }
            previousChar = currentChar;
        }
        if (index > strStart) {
            result.add(stat.substring(strStart, index));
        }
        return result;
    }

    private void sendStats(String newStats, ClientConnection ownerConnection) {
        block2: {
            ClientMessage request = ClientStatisticsCodec.encodeRequest(newStats);
            try {
                new ClientInvocation(this.client, request, null, ownerConnection).invoke();
            }
            catch (Exception e) {
                if (!this.logger.isFinestEnabled()) break block2;
                this.logger.finest("Could not send stats ", e);
            }
        }
    }

    class PeriodicStatistics {
        private final Gauge[] allGauges;

        PeriodicStatistics() {
            this.allGauges = new Gauge[]{Statistics.this.metricsRegistry.newLongGauge("os.committedVirtualMemorySize"), Statistics.this.metricsRegistry.newLongGauge("os.freePhysicalMemorySize"), Statistics.this.metricsRegistry.newLongGauge("os.freeSwapSpaceSize"), Statistics.this.metricsRegistry.newLongGauge("os.maxFileDescriptorCount"), Statistics.this.metricsRegistry.newLongGauge("os.openFileDescriptorCount"), Statistics.this.metricsRegistry.newLongGauge("os.processCpuTime"), Statistics.this.metricsRegistry.newDoubleGauge("os.systemLoadAverage"), Statistics.this.metricsRegistry.newLongGauge("os.totalPhysicalMemorySize"), Statistics.this.metricsRegistry.newLongGauge("os.totalSwapSpaceSize"), Statistics.this.metricsRegistry.newLongGauge("runtime.availableProcessors"), Statistics.this.metricsRegistry.newLongGauge("runtime.freeMemory"), Statistics.this.metricsRegistry.newLongGauge("runtime.maxMemory"), Statistics.this.metricsRegistry.newLongGauge("runtime.totalMemory"), Statistics.this.metricsRegistry.newLongGauge("runtime.uptime"), Statistics.this.metricsRegistry.newLongGauge("runtime.usedMemory"), Statistics.this.metricsRegistry.newLongGauge("executionService.userExecutorQueueSize")};
        }

        void fillMetrics(StringBuilder stats, ClientConnection ownerConnection) {
            stats.append("lastStatisticsCollectionTime").append('=').append(System.currentTimeMillis());
            Statistics.this.addStat(stats, "enterprise", Statistics.this.enterprise);
            Statistics.this.addStat(stats, "clientType", ClientType.JAVA.toString());
            Statistics.this.addStat(stats, "clientVersion", BuildInfoProvider.getBuildInfo().getVersion());
            Statistics.this.addStat(stats, "clusterConnectionTimestamp", ownerConnection.getStartTime());
            stats.append(',').append("clientAddress").append('=').append(ownerConnection.getLocalSocketAddress().getAddress().getHostAddress()).append(":").append(ownerConnection.getLocalSocketAddress().getPort());
            Statistics.this.addStat(stats, "clientName", Statistics.this.client.getName());
            ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)Statistics.this.client.getConnectionManager();
            Credentials credentials = connectionManager.getLastCredentials();
            if (credentials != null) {
                Statistics.this.addStat(stats, "credentials.principal", credentials.getPrincipal());
            }
            for (Gauge gauge : this.allGauges) {
                stats.append(',').append(gauge.getName()).append('=');
                gauge.render(stats);
            }
        }
    }
}

