/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCacheConfigAccessor;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.Credentials;
import com.hazelcast.util.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientConfig {
    private static final ILogger LOGGER = Logger.getLogger(ClientConfig.class);
    private Properties properties = new Properties();
    private GroupConfig groupConfig = new GroupConfig();
    private ClientSecurityConfig securityConfig = new ClientSecurityConfig();
    private ClientNetworkConfig networkConfig = new ClientNetworkConfig();
    private LoadBalancer loadBalancer;
    private List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private int executorPoolSize = -1;
    private String instanceName;
    private ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private final Map<String, NearCacheConfig> nearCacheConfigMap = new ConcurrentHashMap<String, NearCacheConfig>();
    private final Map<String, ClientReliableTopicConfig> reliableTopicConfigMap = new ConcurrentHashMap<String, ClientReliableTopicConfig>();
    private Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs;
    private SerializationConfig serializationConfig = new SerializationConfig();
    private NativeMemoryConfig nativeMemoryConfig = new NativeMemoryConfig();
    private final List<ProxyFactoryConfig> proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
    private ManagedContext managedContext;
    private ClassLoader classLoader;
    private String licenseKey;
    private ClientConnectionStrategyConfig connectionStrategyConfig = new ClientConnectionStrategyConfig();
    private ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
    private final Map<String, ClientFlakeIdGeneratorConfig> flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, ClientFlakeIdGeneratorConfig>();
    private ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();

    public void setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        if (configPatternMatcher == null) {
            throw new IllegalArgumentException("ConfigPatternMatcher is not allowed to be null!");
        }
        this.configPatternMatcher = configPatternMatcher;
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        return this.configPatternMatcher;
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        return value != null ? value : System.getProperty(name);
    }

    public ClientConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClientConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ClientSecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public ClientConfig setSecurityConfig(ClientSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    public ClientNetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public ClientConfig setNetworkConfig(ClientNetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public ClientConfig addReliableTopicConfig(ClientReliableTopicConfig reliableTopicConfig) {
        this.reliableTopicConfigMap.put(reliableTopicConfig.getName(), reliableTopicConfig);
        return this;
    }

    public ClientReliableTopicConfig getReliableTopicConfig(String name) {
        ClientReliableTopicConfig reliableTopicConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.reliableTopicConfigMap, name);
        if (reliableTopicConfig == null) {
            reliableTopicConfig = new ClientReliableTopicConfig(name);
            this.addReliableTopicConfig(reliableTopicConfig);
        }
        return reliableTopicConfig;
    }

    @Deprecated
    public ClientConfig addNearCacheConfig(String name, NearCacheConfig nearCacheConfig) {
        nearCacheConfig.setName(name);
        return this.addNearCacheConfig(nearCacheConfig);
    }

    public ClientConfig addNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfigMap.put(nearCacheConfig.getName(), nearCacheConfig);
        return this;
    }

    public ClientConfig addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public ClientConfig addProxyFactoryConfig(ProxyFactoryConfig proxyFactoryConfig) {
        this.proxyFactoryConfigs.add(proxyFactoryConfig);
        return this;
    }

    public NearCacheConfig getNearCacheConfig(String name) {
        NearCacheConfig nearCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.nearCacheConfigMap, name);
        if (nearCacheConfig == null && (nearCacheConfig = this.nearCacheConfigMap.get("default")) != null) {
            nearCacheConfig = new NearCacheConfig(nearCacheConfig);
        }
        NearCacheConfigAccessor.initDefaultMaxSizeForOnHeapMaps(nearCacheConfig);
        return nearCacheConfig;
    }

    public Map<String, NearCacheConfig> getNearCacheConfigMap() {
        return this.nearCacheConfigMap;
    }

    public ClientConfig setNearCacheConfigMap(Map<String, NearCacheConfig> nearCacheConfigMap) {
        this.nearCacheConfigMap.clear();
        this.nearCacheConfigMap.putAll(nearCacheConfigMap);
        for (Map.Entry<String, NearCacheConfig> entry : this.nearCacheConfigMap.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientFlakeIdGeneratorConfig> getFlakeIdGeneratorConfigMap() {
        return this.flakeIdGeneratorConfigMap;
    }

    public ClientFlakeIdGeneratorConfig findFlakeIdGeneratorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ClientFlakeIdGeneratorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, baseName);
        if (config != null) {
            return config;
        }
        return this.getFlakeIdGeneratorConfig("default");
    }

    public ClientFlakeIdGeneratorConfig getFlakeIdGeneratorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ClientFlakeIdGeneratorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, baseName);
        if (config != null) {
            return config;
        }
        ClientFlakeIdGeneratorConfig defConfig = this.flakeIdGeneratorConfigMap.get("default");
        if (defConfig == null) {
            defConfig = new ClientFlakeIdGeneratorConfig("default");
            this.flakeIdGeneratorConfigMap.put(defConfig.getName(), defConfig);
        }
        config = new ClientFlakeIdGeneratorConfig(defConfig);
        config.setName(name);
        this.flakeIdGeneratorConfigMap.put(config.getName(), config);
        return config;
    }

    public ClientConfig addFlakeIdGeneratorConfig(ClientFlakeIdGeneratorConfig config) {
        this.flakeIdGeneratorConfigMap.put(config.getName(), config);
        return this;
    }

    public ClientConfig setFlakeIdGeneratorConfigMap(Map<String, ClientFlakeIdGeneratorConfig> map) {
        this.flakeIdGeneratorConfigMap.clear();
        this.flakeIdGeneratorConfigMap.putAll(map);
        for (Map.Entry<String, ClientFlakeIdGeneratorConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ClientConfig setReliableTopicConfigMap(Map<String, ClientReliableTopicConfig> map) {
        this.reliableTopicConfigMap.clear();
        this.reliableTopicConfigMap.putAll(map);
        for (Map.Entry<String, ClientReliableTopicConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientReliableTopicConfig> getReliableTopicConfigMap() {
        return this.reliableTopicConfigMap;
    }

    @Deprecated
    public boolean isSmartRouting() {
        return this.networkConfig.isSmartRouting();
    }

    @Deprecated
    public ClientConfig setSmartRouting(boolean smartRouting) {
        this.networkConfig.setSmartRouting(smartRouting);
        return this;
    }

    @Deprecated
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.networkConfig.getSocketInterceptorConfig();
    }

    @Deprecated
    public ClientConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.networkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptPeriod() {
        return this.networkConfig.getConnectionAttemptPeriod();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        this.networkConfig.setConnectionAttemptPeriod(connectionAttemptPeriod);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptLimit() {
        return this.networkConfig.getConnectionAttemptLimit();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        this.networkConfig.setConnectionAttemptLimit(connectionAttemptLimit);
        return this;
    }

    @Deprecated
    public int getConnectionTimeout() {
        return this.networkConfig.getConnectionTimeout();
    }

    @Deprecated
    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.networkConfig.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public Credentials getCredentials() {
        return this.securityConfig.getCredentials();
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.securityConfig.setCredentials(credentials);
        return this;
    }

    @Deprecated
    public ClientConfig addAddress(String ... addresses) {
        this.networkConfig.addAddress(addresses);
        return this;
    }

    @Deprecated
    public ClientConfig setAddresses(List<String> addresses) {
        this.networkConfig.setAddresses(addresses);
        return this;
    }

    @Deprecated
    public List<String> getAddresses() {
        return this.networkConfig.getAddresses();
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public ClientConfig setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public ClientConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientConfig setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    @Deprecated
    public boolean isRedoOperation() {
        return this.networkConfig.isRedoOperation();
    }

    @Deprecated
    public ClientConfig setRedoOperation(boolean redoOperation) {
        this.networkConfig.setRedoOperation(redoOperation);
        return this;
    }

    @Deprecated
    public SocketOptions getSocketOptions() {
        return this.networkConfig.getSocketOptions();
    }

    @Deprecated
    public ClientConfig setSocketOptions(SocketOptions socketOptions) {
        this.networkConfig.setSocketOptions(socketOptions);
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClientConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public ClientConfig setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public ClientConfig setExecutorPoolSize(int executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
        return this;
    }

    public List<ProxyFactoryConfig> getProxyFactoryConfigs() {
        return this.proxyFactoryConfigs;
    }

    public ClientConfig setProxyFactoryConfigs(List<ProxyFactoryConfig> proxyFactoryConfigs) {
        this.proxyFactoryConfigs.clear();
        this.proxyFactoryConfigs.addAll(proxyFactoryConfigs);
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ClientConfig setSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        return this.nativeMemoryConfig;
    }

    public ClientConfig setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        this.nativeMemoryConfig = nativeMemoryConfig;
        return this;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public ClientConfig setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public ClientConfig addQueryCacheConfig(String mapName, QueryCacheConfig queryCacheConfig) {
        Map<String, Map<String, QueryCacheConfig>> queryCacheConfigsPerMap = this.getQueryCacheConfigs();
        String queryCacheName = queryCacheConfig.getName();
        Map<String, QueryCacheConfig> queryCacheConfigs = queryCacheConfigsPerMap.get(mapName);
        if (queryCacheConfigs != null) {
            Preconditions.checkFalse(queryCacheConfigs.containsKey(queryCacheName), "A query cache already exists with name = [" + queryCacheName + ']');
        } else {
            queryCacheConfigs = new ConcurrentHashMap<String, QueryCacheConfig>();
            queryCacheConfigsPerMap.put(mapName, queryCacheConfigs);
        }
        queryCacheConfigs.put(queryCacheName, queryCacheConfig);
        return this;
    }

    public Map<String, Map<String, QueryCacheConfig>> getQueryCacheConfigs() {
        if (this.queryCacheConfigs == null) {
            this.queryCacheConfigs = new ConcurrentHashMap<String, Map<String, QueryCacheConfig>>();
        }
        return this.queryCacheConfigs;
    }

    public void setQueryCacheConfigs(Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs) {
        this.queryCacheConfigs = queryCacheConfigs;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClientConnectionStrategyConfig getConnectionStrategyConfig() {
        return this.connectionStrategyConfig;
    }

    public ClientConfig setConnectionStrategyConfig(ClientConnectionStrategyConfig connectionStrategyConfig) {
        this.connectionStrategyConfig = connectionStrategyConfig;
        return this;
    }

    public ClientUserCodeDeploymentConfig getUserCodeDeploymentConfig() {
        return this.userCodeDeploymentConfig;
    }

    public ClientConfig setUserCodeDeploymentConfig(ClientUserCodeDeploymentConfig userCodeDeploymentConfig) {
        this.userCodeDeploymentConfig = userCodeDeploymentConfig;
        return this;
    }

    public QueryCacheConfig getOrCreateQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfig queryCacheConfig;
        Map<String, Map<String, QueryCacheConfig>> allQueryCacheConfig = this.getQueryCacheConfigs();
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, allQueryCacheConfig, mapName);
        if (queryCacheConfigsForMap == null) {
            queryCacheConfigsForMap = new HashMap<String, QueryCacheConfig>();
            allQueryCacheConfig.put(mapName, queryCacheConfigsForMap);
        }
        if ((queryCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName)) == null) {
            queryCacheConfig = new QueryCacheConfig(cacheName);
            queryCacheConfigsForMap.put(cacheName, queryCacheConfig);
        }
        return queryCacheConfig;
    }

    public QueryCacheConfig getOrNullQueryCacheConfig(String mapName, String cacheName) {
        if (this.queryCacheConfigs == null) {
            return null;
        }
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.queryCacheConfigs, mapName);
        if (queryCacheConfigsForMap == null) {
            return null;
        }
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName);
    }

    public ClientConfig setUserContext(ConcurrentMap<String, Object> userContext) {
        if (userContext == null) {
            throw new IllegalArgumentException("userContext can't be null");
        }
        this.userContext = userContext;
        return this;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }
}

