/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.core.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class SmartClientListenerService
extends AbstractClientListenerService {
    public SmartClientListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public void start() {
        super.start();
        final ClientClusterService clientClusterService = this.client.getClientClusterService();
        this.registrationExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Collection<Member> memberList = clientClusterService.getMemberList();
                for (Member member : memberList) {
                    try {
                        SmartClientListenerService.this.clientConnectionManager.getOrTriggerConnect(member.getAddress(), false);
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public String registerListener(ListenerMessageCodec codec, EventHandler handler) {
        this.trySyncConnectToAllMembers();
        return super.registerListener(codec, handler);
    }

    @Override
    boolean registersLocalOnly() {
        return true;
    }

    private void trySyncConnectToAllMembers() {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        long startMillis = System.currentTimeMillis();
        do {
            Member lastFailedMember = null;
            Exception lastException = null;
            for (Member member : clientClusterService.getMemberList()) {
                try {
                    this.clientConnectionManager.getOrConnect(member.getAddress());
                }
                catch (Exception e) {
                    lastFailedMember = member;
                    lastException = e;
                }
            }
            if (lastException == null) break;
            this.timeOutOrSleepBeforeNextTry(startMillis, lastFailedMember, lastException);
        } while (this.client.getLifecycleService().isRunning());
    }

    private void timeOutOrSleepBeforeNextTry(long startMillis, Member lastFailedMember, Exception lastException) {
        boolean timedOut;
        long nowInMillis = System.currentTimeMillis();
        long elapsedMillis = nowInMillis - startMillis;
        boolean bl = timedOut = elapsedMillis > this.invocationTimeoutMillis;
        if (timedOut) {
            this.throwOperationTimeoutException(startMillis, nowInMillis, elapsedMillis, lastFailedMember, lastException);
        } else {
            this.sleepBeforeNextTry();
        }
    }

    private void sleepBeforeNextTry() {
        try {
            Thread.sleep(this.invocationRetryPauseMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void throwOperationTimeoutException(long startMillis, long nowInMillis, long elapsedMillis, Member lastFailedMember, Exception lastException) {
        throw new OperationTimeoutException("Registering listeners is timed out. Last failed member : " + lastFailedMember + ",  Current time: " + StringUtil.timeToString(nowInMillis) + ",  Start time : " + StringUtil.timeToString(startMillis) + ",  Client invocation timeout : " + this.invocationTimeoutMillis + " ms,  Elapsed time : " + elapsedMillis + " ms. ", lastException);
    }
}

