/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.monitor.impl.GlobalIndexesStats;
import com.hazelcast.monitor.impl.IndexesStats;
import com.hazelcast.monitor.impl.PartitionIndexesStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.DefaultIndexProvider;
import com.hazelcast.query.impl.GlobalQueryContextProvider;
import com.hazelcast.query.impl.GlobalQueryContextProviderWithStats;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.PartitionQueryContextProvider;
import com.hazelcast.query.impl.PartitionQueryContextProviderWithStats;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryContextProvider;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class Indexes {
    private static final InternalIndex[] EMPTY_INDEX = new InternalIndex[0];
    private final boolean global;
    private final boolean usesCachedQueryableEntries;
    private final IndexesStats stats;
    private final Extractors extractors;
    private final IndexProvider indexProvider;
    private final IndexCopyBehavior indexCopyBehavior;
    private final QueryContextProvider queryContextProvider;
    private final InternalSerializationService serializationService;
    private final ConcurrentMap<String, InternalIndex> mapIndexes = new ConcurrentHashMap<String, InternalIndex>(3);
    private final AtomicReference<InternalIndex[]> indexes = new AtomicReference<InternalIndex[]>(EMPTY_INDEX);
    private volatile boolean hasIndex;

    private Indexes(InternalSerializationService serializationService, IndexCopyBehavior indexCopyBehavior, Extractors extractors, IndexProvider indexProvider, boolean usesCachedQueryableEntries, boolean statisticsEnabled, boolean global) {
        this.global = global;
        this.indexCopyBehavior = indexCopyBehavior;
        this.serializationService = serializationService;
        this.usesCachedQueryableEntries = usesCachedQueryableEntries;
        this.stats = Indexes.createStats(global, statisticsEnabled);
        this.extractors = extractors == null ? Extractors.empty() : extractors;
        this.indexProvider = indexProvider == null ? new DefaultIndexProvider() : indexProvider;
        this.queryContextProvider = Indexes.createQueryContextProvider(this, global, statisticsEnabled);
    }

    private static QueryContextProvider createQueryContextProvider(Indexes indexes, boolean global, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            return global ? new GlobalQueryContextProviderWithStats() : new PartitionQueryContextProviderWithStats(indexes);
        }
        return global ? new GlobalQueryContextProvider() : new PartitionQueryContextProvider(indexes);
    }

    private static IndexesStats createStats(boolean global, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            return global ? new GlobalIndexesStats() : new PartitionIndexesStats();
        }
        return IndexesStats.EMPTY;
    }

    public synchronized InternalIndex addOrGetIndex(String attribute, boolean ordered) {
        InternalIndex index = (InternalIndex)this.mapIndexes.get(attribute);
        if (index != null) {
            return index;
        }
        index = this.indexProvider.createIndex(attribute, ordered, this.extractors, this.serializationService, this.indexCopyBehavior, this.stats.createPerIndexStats(ordered, this.usesCachedQueryableEntries));
        this.mapIndexes.put(attribute, index);
        this.indexes.set(this.mapIndexes.values().toArray(EMPTY_INDEX));
        this.hasIndex = true;
        return index;
    }

    public InternalIndex[] getIndexes() {
        return this.indexes.get();
    }

    public void destroyIndexes() {
        for (InternalIndex index : this.getIndexes()) {
            index.destroy();
        }
        this.indexes.set(EMPTY_INDEX);
        this.mapIndexes.clear();
        this.hasIndex = false;
    }

    public void clearAll() {
        for (InternalIndex index : this.getIndexes()) {
            index.clear();
        }
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public void saveEntryIndex(QueryableEntry queryableEntry, Object oldValue, Index.OperationSource operationSource) {
        InternalIndex[] indexes;
        for (InternalIndex index : indexes = this.getIndexes()) {
            index.saveEntryIndex(queryableEntry, oldValue, operationSource);
        }
    }

    public void removeEntryIndex(Data key, Object value, Index.OperationSource operationSource) {
        InternalIndex[] indexes;
        for (InternalIndex index : indexes = this.getIndexes()) {
            index.removeEntryIndex(key, value, operationSource);
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public InternalIndex getIndex(String attribute) {
        return (InternalIndex)this.mapIndexes.get(attribute);
    }

    public Set<QueryableEntry> query(Predicate predicate) {
        this.stats.incrementQueryCount();
        if (!this.hasIndex || !(predicate instanceof IndexAwarePredicate)) {
            return null;
        }
        IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)predicate;
        QueryContext queryContext = this.queryContextProvider.obtainContextFor(this);
        if (!indexAwarePredicate.isIndexed(queryContext)) {
            return null;
        }
        Set<QueryableEntry> result = indexAwarePredicate.filter(queryContext);
        if (result != null) {
            this.stats.incrementIndexedQueryCount();
            queryContext.applyPerQueryStats();
        }
        return result;
    }

    public IndexesStats getIndexesStats() {
        return this.stats;
    }

    public static Builder newBuilder(SerializationService ss, IndexCopyBehavior indexCopyBehavior) {
        return new Builder(ss, indexCopyBehavior);
    }

    public static final class Builder {
        private boolean global = true;
        private boolean statsEnabled;
        private boolean usesCachedQueryableEntries;
        private Extractors extractors;
        private IndexProvider indexProvider;
        private final IndexCopyBehavior indexCopyBehavior;
        private final InternalSerializationService serializationService;

        Builder(SerializationService ss, IndexCopyBehavior indexCopyBehavior) {
            this.serializationService = Preconditions.checkNotNull((InternalSerializationService)ss, "serializationService cannot be null");
            this.indexCopyBehavior = Preconditions.checkNotNull(indexCopyBehavior, "indexCopyBehavior cannot be null");
        }

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder indexProvider(IndexProvider indexProvider) {
            this.indexProvider = indexProvider;
            return this;
        }

        public Builder extractors(Extractors extractors) {
            this.extractors = extractors;
            return this;
        }

        public Builder usesCachedQueryableEntries(boolean usesCachedQueryableEntries) {
            this.usesCachedQueryableEntries = usesCachedQueryableEntries;
            return this;
        }

        public Builder statsEnabled(boolean statsEnabled) {
            this.statsEnabled = statsEnabled;
            return this;
        }

        public Indexes build() {
            return new Indexes(this.serializationService, this.indexCopyBehavior, this.extractors, this.indexProvider, this.usesCachedQueryableEntries, this.statsEnabled, this.global);
        }
    }
}

