/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.util.PropertiesHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private static final int CONNECTION_ATTEMPT_LIMIT = 10;
    private HazelcastInstance client;
    private ClientConfig clientConfig;
    private String instanceName;

    HazelcastClientLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.instanceName = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_instance_name", (Properties)props, null);
        if (this.instanceName != null) {
            return;
        }
        String address = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_address", (Properties)props, null);
        String group = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_group", (Properties)props, null);
        String pass = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_password", (Properties)props, null);
        String configResourcePath = CacheEnvironment.getConfigFilePath(props);
        if (configResourcePath != null) {
            try {
                this.clientConfig = new XmlClientConfigBuilder(configResourcePath).build();
            }
            catch (IOException e) {
                throw new HazelcastException("Could not load client configuration: " + configResourcePath, e);
            }
        } else {
            this.clientConfig = new ClientConfig();
        }
        if (group != null) {
            this.clientConfig.getGroupConfig().setName(group);
        }
        if (pass != null) {
            this.clientConfig.getGroupConfig().setPassword(pass);
        }
        if (address != null) {
            this.clientConfig.getNetworkConfig().addAddress(address);
        }
        this.clientConfig.getNetworkConfig().setSmartRouting(true);
        this.clientConfig.getNetworkConfig().setRedoOperation(true);
        this.clientConfig.getNetworkConfig().setConnectionAttemptLimit(10);
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        if (this.instanceName != null) {
            this.client = HazelcastClient.getHazelcastClientByName(this.instanceName);
            if (this.client == null) {
                throw new CacheException("No client with name [" + this.instanceName + "] could be found.");
            }
        } else {
            this.client = HazelcastClient.newHazelcastClient(this.clientConfig);
        }
        return this.client;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.getLifecycleService().shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

