/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;

public final class ExpirationTimeSetter {
    private ExpirationTimeSetter() {
    }

    public static void setExpirationTime(Record record, long maxIdleMillis) {
        long expirationTime = ExpirationTimeSetter.calculateExpirationTime(record, maxIdleMillis);
        record.setExpirationTime(expirationTime);
    }

    private static long calculateExpirationTime(Record record, long maxIdleMillis) {
        long ttl = ExpirationTimeSetter.checkedTime(record.getTtl());
        long ttlExpirationTime = ExpirationTimeSetter.sumForExpiration(ttl, ExpirationTimeSetter.getLifeStartTime(record));
        maxIdleMillis = ExpirationTimeSetter.checkedTime(maxIdleMillis);
        long idleExpirationTime = ExpirationTimeSetter.sumForExpiration(maxIdleMillis, ExpirationTimeSetter.getIdlenessStartTime(record));
        return Math.min(ttlExpirationTime, idleExpirationTime);
    }

    public static long getIdlenessStartTime(Record record) {
        long lastAccessTime = record.getLastAccessTime();
        return lastAccessTime <= 0L ? record.getCreationTime() : lastAccessTime;
    }

    public static long getLifeStartTime(Record record) {
        long lastUpdateTime = record.getLastUpdateTime();
        return lastUpdateTime <= 0L ? record.getCreationTime() : lastUpdateTime;
    }

    private static long checkedTime(long time) {
        return time <= 0L ? Long.MAX_VALUE : time;
    }

    private static long sumForExpiration(long criteriaTime, long now) {
        if (criteriaTime < 0L || now < 0L) {
            throw new IllegalArgumentException("Parameters can not have negative values");
        }
        if (criteriaTime == 0L) {
            return Long.MAX_VALUE;
        }
        long expirationTime = criteriaTime + now;
        if (expirationTime < 0L) {
            return Long.MAX_VALUE;
        }
        return expirationTime;
    }

    public static long calculateMaxIdleMillis(MapConfig mapConfig) {
        int maxIdleSeconds = mapConfig.getMaxIdleSeconds();
        if (maxIdleSeconds == 0) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.SECONDS.toMillis(maxIdleSeconds);
    }

    public static void setTTLAndUpdateExpiryTime(long operationTTLMillis, Record record, MapConfig mapConfig, boolean entryCreated) {
        long ttlMillis = ExpirationTimeSetter.pickTTLMillis(operationTTLMillis, record.getTtl(), mapConfig, entryCreated);
        record.setTtl(ttlMillis);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(mapConfig);
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
    }

    private static long pickTTLMillis(long operationTTLMillis, long existingTTLMillis, MapConfig mapConfig, boolean entryCreated) {
        if (operationTTLMillis > 0L) {
            return ExpirationTimeSetter.checkedTime(operationTTLMillis);
        }
        if (entryCreated && operationTTLMillis < 0L && mapConfig.getTimeToLiveSeconds() > 0) {
            return ExpirationTimeSetter.checkedTime(TimeUnit.SECONDS.toMillis(mapConfig.getTimeToLiveSeconds()));
        }
        if (operationTTLMillis < 0L) {
            return ExpirationTimeSetter.checkedTime(existingTTLMillis);
        }
        return Long.MAX_VALUE;
    }

    public static long calculateExpirationWithDelay(long timeInMillis, long delayMillis, boolean backup) {
        Preconditions.checkNotNegative(timeInMillis, "timeInMillis can't be negative");
        if (backup) {
            long delayedTime = timeInMillis + delayMillis;
            if (delayedTime < 0L) {
                return Long.MAX_VALUE;
            }
            return delayedTime;
        }
        return timeInMillis;
    }
}

