/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.local.Timestamp;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.Value;

public class TimestampsRegionCache
extends LocalRegionCache
implements RegionCache {
    public TimestampsRegionCache(String name, HazelcastInstance hazelcastInstance) {
        super(name, hazelcastInstance, null);
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        boolean succeed = super.put(key, value, txTimestamp, version);
        if (succeed) {
            this.maybeNotifyTopic(key, value, version);
        }
        return succeed;
    }

    @Override
    protected void maybeInvalidate(Object messageObject) {
        Timestamp ts = (Timestamp)messageObject;
        Object key = ts.getKey();
        while (true) {
            Expirable value;
            Long current;
            Long l = current = (value = (Expirable)this.cache.get(key)) != null ? (Long)value.getValue() : null;
            if (current != null) {
                if (ts.getTimestamp() > current) {
                    if (!this.cache.replace(key, value, new Value(value.getVersion(), this.nextTimestamp(), ts.getTimestamp()))) continue;
                    return;
                }
                return;
            }
            if (this.cache.putIfAbsent(key, new Value(null, this.nextTimestamp(), ts.getTimestamp())) == null) break;
        }
    }

    @Override
    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Timestamp(key, (Long)value);
    }

    @Override
    final void cleanup() {
    }
}

