/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ClientXmlElements;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.QueryCacheConfigBuilderHelper;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.config.XmlClientConfigLocator;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractConfigBuilder;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlClientConfigBuilder
extends AbstractConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlClientConfigBuilder.class);
    private final QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper = new QueryCacheConfigBuilderHelper();
    private final Set<String> occurrenceSet = new HashSet<String>();
    private final InputStream in;
    private Properties properties = System.getProperties();
    private ClientConfig clientConfig;

    public XmlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig(resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.in = new FileInputStream(file);
    }

    public XmlClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public XmlClientConfigBuilder() {
        XmlClientConfigLocator locator = new XmlClientConfigLocator();
        this.in = locator.getIn();
    }

    @Override
    protected Document parse(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        catch (Exception e) {
            String msg = "Failed to parse Config Stream" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "HazelcastClient startup interrupted.";
            LOGGER.severe(msg);
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        finally {
            IOUtil.closeResource(inputStream);
        }
    }

    @Override
    protected Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected AbstractConfigBuilder.ConfigType getXmlType() {
        return AbstractConfigBuilder.ConfigType.CLIENT;
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        this.build(clientConfig, classLoader);
        return clientConfig;
    }

    void build(ClientConfig clientConfig, ClassLoader classLoader) {
        clientConfig.setClassLoader(classLoader);
        try {
            this.parseAndBuildConfig(clientConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
    }

    private void parseAndBuildConfig(ClientConfig clientConfig) throws Exception {
        this.clientConfig = clientConfig;
        Document doc = this.parse(this.in);
        Element root = doc.getDocumentElement();
        this.checkRootElement(root);
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        this.schemaValidation(root.getOwnerDocument());
        this.handleConfig(root);
    }

    private void checkRootElement(Element root) {
        String rootNodeName = root.getNodeName();
        if (!ClientXmlElements.HAZELCAST_CLIENT.isEqual(rootNodeName)) {
            throw new InvalidConfigurationException("Invalid root element in xml configuration! Expected: <" + ClientXmlElements.HAZELCAST_CLIENT.name + ">, Actual: <" + rootNodeName + ">.");
        }
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : XmlClientConfigBuilder.childElements(docElement)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in XML configuration");
            }
            this.handleXmlNode(node, nodeName);
            if (ClientXmlElements.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private void handleXmlNode(Node node, String nodeName) throws Exception {
        if (ClientXmlElements.SECURITY.isEqual(nodeName)) {
            this.handleSecurity(node);
        } else if (ClientXmlElements.PROXY_FACTORIES.isEqual(nodeName)) {
            this.handleProxyFactories(node);
        } else if (ClientXmlElements.PROPERTIES.isEqual(nodeName)) {
            this.fillProperties(node, this.clientConfig.getProperties());
        } else if (ClientXmlElements.SERIALIZATION.isEqual(nodeName)) {
            this.handleSerialization(node);
        } else if (ClientXmlElements.NATIVE_MEMORY.isEqual(nodeName)) {
            this.fillNativeMemoryConfig(node, this.clientConfig.getNativeMemoryConfig());
        } else if (ClientXmlElements.GROUP.isEqual(nodeName)) {
            this.handleGroup(node);
        } else if (ClientXmlElements.LISTENERS.isEqual(nodeName)) {
            this.handleListeners(node);
        } else if (ClientXmlElements.NETWORK.isEqual(nodeName)) {
            this.handleNetwork(node);
        } else if (ClientXmlElements.LOAD_BALANCER.isEqual(nodeName)) {
            this.handleLoadBalancer(node);
        } else if (ClientXmlElements.NEAR_CACHE.isEqual(nodeName)) {
            this.handleNearCache(node);
        } else if (ClientXmlElements.QUERY_CACHES.isEqual(nodeName)) {
            this.queryCacheConfigBuilderHelper.handleQueryCache(this.clientConfig, node);
        } else if (ClientXmlElements.EXECUTOR_POOL_SIZE.isEqual(nodeName)) {
            this.handleExecutorPoolSize(node);
        } else if (ClientXmlElements.LICENSE_KEY.isEqual(nodeName)) {
            this.clientConfig.setLicenseKey(this.getTextContent(node));
        } else if (ClientXmlElements.INSTANCE_NAME.isEqual(nodeName)) {
            this.clientConfig.setInstanceName(this.getTextContent(node));
        } else if (ClientXmlElements.CONNECTION_STRATEGY.isEqual(nodeName)) {
            this.handleConnectionStrategy(node);
        } else if (ClientXmlElements.USER_CODE_DEPLOYMENT.isEqual(nodeName)) {
            this.handleUserCodeDeployment(node);
        } else if (ClientXmlElements.FLAKE_ID_GENERATOR.isEqual(nodeName)) {
            this.handleFlakeIdGenerator(node);
        }
    }

    private void handleConnectionStrategy(Node node) {
        ClientConnectionStrategyConfig strategyConfig = new ClientConnectionStrategyConfig();
        String attrValue = this.getAttribute(node, "async-start");
        strategyConfig.setAsyncStart(attrValue != null && XmlClientConfigBuilder.getBooleanValue(attrValue.trim()));
        attrValue = this.getAttribute(node, "reconnect-mode");
        if (attrValue != null) {
            strategyConfig.setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.valueOf(StringUtil.upperCaseInternal(attrValue.trim())));
        }
        this.clientConfig.setConnectionStrategyConfig(strategyConfig);
    }

    private void handleUserCodeDeployment(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlClientConfigBuilder.getBooleanValue(this.getTextContent(enabledNode).trim());
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        userCodeDeploymentConfig.setEnabled(enabled);
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String childNodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if ("classnames".equals(childNodeName)) {
                for (Node classNameNode : XmlClientConfigBuilder.childElements(child)) {
                    userCodeDeploymentConfig.addClass(this.getTextContent(classNameNode));
                }
                continue;
            }
            if ("jarpaths".equals(childNodeName)) {
                for (Node jarPathNode : XmlClientConfigBuilder.childElements(child)) {
                    userCodeDeploymentConfig.addJar(this.getTextContent(jarPathNode));
                }
                continue;
            }
            throw new InvalidConfigurationException("User code deployement can either be className or jarPath. " + childNodeName + " is invalid");
        }
        this.clientConfig.setUserCodeDeploymentConfig(userCodeDeploymentConfig);
    }

    private void handleExecutorPoolSize(Node node) {
        int poolSize = Integer.parseInt(this.getTextContent(node));
        this.clientConfig.setExecutorPoolSize(poolSize);
    }

    private void handleNearCache(Node node) {
        String name = this.getAttribute(node, "name");
        NearCacheConfig nearCacheConfig = new NearCacheConfig(name);
        Boolean serializeKeys = null;
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("max-size".equals(nodeName)) {
                nearCacheConfig.setMaxSize(Integer.parseInt(value));
                LOGGER.warning("The element <max-size/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(value));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(value));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                nearCacheConfig.setEvictionPolicy(value);
                LOGGER.warning("The element <eviction-policy/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("serialize-keys".equals(nodeName)) {
                serializeKeys = Boolean.parseBoolean(value);
                nearCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if ("invalidate-on-change".equals(nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(value));
                continue;
            }
            if ("cache-local-entries".equals(nodeName)) {
                nearCacheConfig.setCacheLocalEntries(Boolean.parseBoolean(value));
                continue;
            }
            if ("local-update-policy".equals(nodeName)) {
                nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.valueOf(value));
                continue;
            }
            if ("eviction".equals(nodeName)) {
                nearCacheConfig.setEvictionConfig(this.getEvictionConfig(child));
                continue;
            }
            if (!"preloader".equals(nodeName)) continue;
            nearCacheConfig.setPreloaderConfig(this.getNearCachePreloaderConfig(child));
        }
        if (serializeKeys != null && !serializeKeys.booleanValue() && nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            LOGGER.warning("The Near Cache doesn't support keys by-reference with NATIVE in-memory-format. This setting will have no effect!");
        }
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
    }

    private void handleFlakeIdGenerator(Node node) {
        String name = this.getAttribute(node, "name");
        ClientFlakeIdGeneratorConfig config = new ClientFlakeIdGeneratorConfig(name);
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("prefetch-count".equals(nodeName)) {
                config.setPrefetchCount(Integer.parseInt(value));
                continue;
            }
            if (!"prefetch-validity-millis".equalsIgnoreCase(nodeName)) continue;
            config.setPrefetchValidityMillis(Long.parseLong(value));
        }
        this.clientConfig.addFlakeIdGeneratorConfig(config);
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        return evictionConfig;
    }

    private NearCachePreloaderConfig getNearCachePreloaderConfig(Node node) {
        NearCachePreloaderConfig preloaderConfig = new NearCachePreloaderConfig();
        String enabled = this.getAttribute(node, "enabled");
        String directory = this.getAttribute(node, "directory");
        String storeInitialDelaySeconds = this.getAttribute(node, "store-initial-delay-seconds");
        String storeIntervalSeconds = this.getAttribute(node, "store-interval-seconds");
        if (enabled != null) {
            preloaderConfig.setEnabled(XmlClientConfigBuilder.getBooleanValue(enabled));
        }
        if (directory != null) {
            preloaderConfig.setDirectory(directory);
        }
        if (storeInitialDelaySeconds != null) {
            preloaderConfig.setStoreInitialDelaySeconds(XmlClientConfigBuilder.getIntegerValue("storage-initial-delay-seconds", storeInitialDelaySeconds));
        }
        if (storeIntervalSeconds != null) {
            preloaderConfig.setStoreIntervalSeconds(XmlClientConfigBuilder.getIntegerValue("storage-interval-seconds", storeIntervalSeconds));
        }
        return preloaderConfig;
    }

    private void handleLoadBalancer(Node node) {
        String type = this.getAttribute(node, "type");
        if ("random".equals(type)) {
            this.clientConfig.setLoadBalancer(new RandomLB());
        } else if ("round-robin".equals(type)) {
            this.clientConfig.setLoadBalancer(new RoundRobinLB());
        }
    }

    private void handleNetwork(Node node) {
        ClientNetworkConfig clientNetworkConfig = new ClientNetworkConfig();
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if ("cluster-members".equals(nodeName)) {
                this.handleClusterMembers(child, clientNetworkConfig);
                continue;
            }
            if ("smart-routing".equals(nodeName)) {
                clientNetworkConfig.setSmartRouting(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("redo-operation".equals(nodeName)) {
                clientNetworkConfig.setRedoOperation(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("connection-timeout".equals(nodeName)) {
                clientNetworkConfig.setConnectionTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-period".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptPeriod(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-limit".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptLimit(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("socket-options".equals(nodeName)) {
                this.handleSocketOptions(child, clientNetworkConfig);
                continue;
            }
            if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child, clientNetworkConfig);
                continue;
            }
            if ("aws".equals(nodeName)) {
                this.handleAWS(child, clientNetworkConfig);
                continue;
            }
            if ("discovery-strategies".equals(nodeName)) {
                this.handleDiscoveryStrategies(child, clientNetworkConfig);
                continue;
            }
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(child, clientNetworkConfig);
                continue;
            }
            if (!"icmp-ping".equals(nodeName)) continue;
            this.handleIcmpPing(child, clientNetworkConfig);
        }
        this.clientConfig.setNetworkConfig(clientNetworkConfig);
    }

    private void handleIcmpPing(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientIcmpPingConfig icmpPingConfig = clientNetworkConfig.getClientIcmpPingConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlClientConfigBuilder.getBooleanValue(this.getTextContent(enabledNode).trim());
        icmpPingConfig.setEnabled(enabled);
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if ("timeout-milliseconds".equals(nodeName)) {
                icmpPingConfig.setTimeoutMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("interval-milliseconds".equals(nodeName)) {
                icmpPingConfig.setIntervalMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("ttl".equals(nodeName)) {
                icmpPingConfig.setTtl(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("max-attempts".equals(nodeName)) {
                icmpPingConfig.setMaxAttempts(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"echo-fail-fast-on-startup".equals(nodeName)) continue;
            icmpPingConfig.setEchoFailFastOnStartup(Boolean.parseBoolean(this.getTextContent(child)));
        }
        clientNetworkConfig.setClientIcmpPingConfig(icmpPingConfig);
    }

    private void handleDiscoveryStrategies(Node node, ClientNetworkConfig clientNetworkConfig) {
        DiscoveryConfig discoveryConfig = clientNetworkConfig.getDiscoveryConfig();
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String name = XmlClientConfigBuilder.cleanNodeName(child);
            if ("discovery-strategy".equals(name)) {
                this.handleDiscoveryStrategy(child, discoveryConfig);
                continue;
            }
            if (!"node-filter".equals(name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    private void handleDiscoveryNodeFilter(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem("class");
        if (att != null) {
            discoveryConfig.setNodeFilterClass(this.getTextContent(att).trim());
        }
    }

    private void handleDiscoveryStrategy(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap atts = node.getAttributes();
        boolean enabled = false;
        String clazz = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                enabled = XmlClientConfigBuilder.getBooleanValue(value);
                continue;
            }
            if (!"class".equals(att.getNodeName())) continue;
            clazz = value;
        }
        if (!enabled || clazz == null) {
            return;
        }
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String name = XmlClientConfigBuilder.cleanNodeName(child);
            if (!"properties".equals(name)) continue;
            this.fillProperties(child, properties);
        }
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(clazz, properties));
    }

    private void handleAWS(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientAwsConfig clientAwsConfig = this.handleAwsAttributes(node);
        for (Node n : XmlClientConfigBuilder.childElements(node)) {
            String value = this.getTextContent(n).trim();
            if ("secret-key".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setSecretKey(value);
                continue;
            }
            if ("access-key".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setAccessKey(value);
                continue;
            }
            if ("region".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setRegion(value);
                continue;
            }
            if ("host-header".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setHostHeader(value);
                continue;
            }
            if ("security-group-name".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setSecurityGroupName(value);
                continue;
            }
            if ("tag-key".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setTagKey(value);
                continue;
            }
            if ("tag-value".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setTagValue(value);
                continue;
            }
            if ("inside-aws".equals(XmlClientConfigBuilder.cleanNodeName(n))) {
                clientAwsConfig.setInsideAws(XmlClientConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!"iam-role".equals(XmlClientConfigBuilder.cleanNodeName(n))) continue;
            clientAwsConfig.setIamRole(value);
        }
        if (!clientAwsConfig.isInsideAws() && clientAwsConfig.getIamRole() != null) {
            throw new InvalidConfigurationException("You cannot set IAM Role from outside EC2");
        }
        clientNetworkConfig.setAwsConfig(clientAwsConfig);
    }

    private ClientAwsConfig handleAwsAttributes(Node node) {
        NamedNodeMap atts = node.getAttributes();
        ClientAwsConfig clientAwsConfig = new ClientAwsConfig();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node att = atts.item(i);
            String value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                clientAwsConfig.setEnabled(XmlClientConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            int timeout = XmlClientConfigBuilder.getIntegerValue("connection-timeout-seconds", value);
            clientAwsConfig.setConnectionTimeoutSeconds(timeout);
        }
        return clientAwsConfig;
    }

    private void handleSSLConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlClientConfigBuilder.getBooleanValue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(n);
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        clientNetworkConfig.setSSLConfig(sslConfig);
    }

    private void handleSocketOptions(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketOptions socketOptions = this.clientConfig.getSocketOptions();
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if ("tcp-no-delay".equals(nodeName)) {
                socketOptions.setTcpNoDelay(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("keep-alive".equals(nodeName)) {
                socketOptions.setKeepAlive(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("reuse-address".equals(nodeName)) {
                socketOptions.setReuseAddress(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("linger-seconds".equals(nodeName)) {
                socketOptions.setLingerSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"buffer-size".equals(nodeName)) continue;
            socketOptions.setBufferSize(Integer.parseInt(this.getTextContent(child)));
        }
        clientNetworkConfig.setSocketOptions(socketOptions);
    }

    private void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            if (!"address".equals(XmlClientConfigBuilder.cleanNodeName(child))) continue;
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    private void handleListeners(Node node) throws Exception {
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            if (!"listener".equals(XmlClientConfigBuilder.cleanNodeName(child))) continue;
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    private void handleGroup(Node node) {
        for (Node n : XmlClientConfigBuilder.childElements(node)) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlClientConfigBuilder.cleanNodeName(n);
            if ("name".equals(nodeName)) {
                this.clientConfig.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.clientConfig.getGroupConfig().setPassword(value);
        }
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.clientConfig.setSerializationConfig(serializationConfig);
    }

    private void handleProxyFactories(Node node) throws Exception {
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if (!"proxy-factory".equals(nodeName)) continue;
            this.handleProxyFactory(child);
        }
    }

    private void handleProxyFactory(Node node) throws Exception {
        String service = this.getAttribute(node, "service");
        String className = this.getAttribute(node, "class-name");
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig(className, service);
        this.clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
    }

    private void handleSocketInterceptorConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        clientNetworkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleSecurity(Node node) throws Exception {
        ClientSecurityConfig clientSecurityConfig = new ClientSecurityConfig();
        for (Node child : XmlClientConfigBuilder.childElements(node)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child);
            if (!"credentials".equals(nodeName)) continue;
            String className = this.getTextContent(child);
            clientSecurityConfig.setCredentialsClassname(className);
        }
        this.clientConfig.setSecurityConfig(clientSecurityConfig);
    }

    private void handleOutboundPorts(Node child, ClientNetworkConfig clientNetworkConfig) {
        for (Node n : XmlClientConfigBuilder.childElements(child)) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(n);
            if (!"ports".equals(nodeName)) continue;
            String value = this.getTextContent(n);
            clientNetworkConfig.addOutboundPortDefinition(value);
        }
    }
}

