/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheEntryViews;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.hazelcast.cache.impl.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ServiceNamespaceAware;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutAllOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable,
BackupAwareOperation,
ServiceNamespaceAware,
MutableOperation,
MutatingOperation {
    private List<Map.Entry<Data, Data>> entries;
    private ExpiryPolicy expiryPolicy;
    private int completionId;
    private transient ICacheRecordStore cache;
    private transient Map<Data, CacheRecord> backupRecords;

    public CachePutAllOperation() {
    }

    public CachePutAllOperation(String cacheNameWithPrefix, List<Map.Entry<Data, Data>> entries, ExpiryPolicy expiryPolicy, int completionId) {
        super(cacheNameWithPrefix);
        this.entries = entries;
        this.expiryPolicy = expiryPolicy;
        this.completionId = completionId;
    }

    @Override
    public int getCompletionId() {
        return this.completionId;
    }

    @Override
    public void setCompletionId(int completionId) {
        this.completionId = completionId;
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        String callerUuid = this.getCallerUuid();
        ICacheService service = (ICacheService)this.getService();
        this.cache = service.getOrCreateRecordStore(this.name, partitionId);
        this.backupRecords = MapUtil.createHashMap(this.entries.size());
        for (Map.Entry<Data, Data> entry : this.entries) {
            Data value;
            Data key = entry.getKey();
            CacheRecord backupRecord = this.cache.put(key, value = entry.getValue(), this.expiryPolicy, callerUuid, this.completionId);
            if (backupRecord != null) {
                this.backupRecords.put(key, backupRecord);
            }
            this.publishWanEvent(key, value, backupRecord);
        }
    }

    private void publishWanEvent(Data key, Data value, CacheRecord backupRecord) {
        if (this.cache.isWanReplicationEnabled()) {
            ICacheService service = (ICacheService)this.getService();
            CacheWanEventPublisher publisher = service.getCacheWanEventPublisher();
            publisher.publishWanReplicationUpdate(this.name, CacheEntryViews.createDefaultEntryView(key, value, backupRecord));
        }
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupRecords.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupRecords);
    }

    @Override
    public int getId() {
        return 37;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public ObjectNamespace getServiceNamespace() {
        ICacheRecordStore recordStore = this.cache;
        if (recordStore == null) {
            ICacheService service = (ICacheService)this.getService();
            recordStore = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        }
        return recordStore.getObjectNamespace();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        out.writeInt(this.completionId);
        out.writeInt(this.entries.size());
        for (Map.Entry<Data, Data> entry : this.entries) {
            out.writeData(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        this.completionId = in.readInt();
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
        }
    }
}

