/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryDispatcher;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.BitSetUtils;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class MapQueryEngineImpl
implements MapQueryEngine {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final InternalSerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final QueryDispatcher queryDispatcher;
    protected final ResultProcessorRegistry resultProcessorRegistry;

    public MapQueryEngineImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.queryDispatcher = new QueryDispatcher(mapServiceContext);
        this.resultProcessorRegistry = mapServiceContext.getResultProcessorRegistry();
    }

    public Result execute(Query query, Target target) {
        Query adjustedQuery = this.adjustQuery(query);
        if (target.isTargetAllNodes()) {
            return this.runQueryOnAllPartitions(adjustedQuery);
        }
        if (target.isTargetLocalNode()) {
            return this.runQueryOnLocalPartitions(adjustedQuery);
        }
        if (target.isTargetPartitionOwner()) {
            return this.runQueryOnGivenPartition(adjustedQuery, target);
        }
        throw new IllegalArgumentException("Illegal target " + query);
    }

    private Query adjustQuery(Query query) {
        IterationType retrievalIterationType = this.getRetrievalIterationType(query.getPredicate(), query.getIterationType());
        Query adjustedQuery = Query.of(query).iterationType(retrievalIterationType).build();
        if (adjustedQuery.getPredicate() instanceof PagingPredicate) {
            ((PagingPredicate)adjustedQuery.getPredicate()).setIterationType(query.getIterationType());
        } else if (adjustedQuery.getPredicate() == TruePredicate.INSTANCE) {
            this.queryResultSizeLimiter.precheckMaxResultLimitOnLocalPartitions(adjustedQuery.getMapName());
        }
        return adjustedQuery;
    }

    private Result runQueryOnLocalPartitions(Query query) {
        BitSet mutablePartitionIds = this.getLocalPartitionIds();
        Result result = this.doRunQueryOnQueryThreads(query, mutablePartitionIds, Target.LOCAL_NODE);
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            this.doRunQueryOnPartitionThreads(query, mutablePartitionIds, result);
        }
        this.assertAllPartitionsQueried(mutablePartitionIds);
        return result;
    }

    private Result runQueryOnAllPartitions(Query query) {
        BitSet mutablePartitionIds = this.getAllPartitionIds();
        Result result = this.doRunQueryOnQueryThreads(query, mutablePartitionIds, Target.ALL_NODES);
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            this.doRunQueryOnPartitionThreads(query, mutablePartitionIds, result);
        }
        this.assertAllPartitionsQueried(mutablePartitionIds);
        return result;
    }

    private Result runQueryOnGivenPartition(Query query, Target target) {
        try {
            return this.queryDispatcher.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, target.getPartitionId()).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Result doRunQueryOnQueryThreads(Query query, BitSet partitionIds, Target target) {
        Result result = this.populateResult(query, partitionIds);
        List<Future<Result>> futures = this.dispatchOnQueryThreads(query, target);
        this.addResultsOfPredicate(futures, result, partitionIds, false);
        return result;
    }

    private List<Future<Result>> dispatchOnQueryThreads(Query query, Target target) {
        try {
            return this.queryDispatcher.dispatchFullQueryOnQueryThread(query, target);
        }
        catch (Throwable t) {
            if (!(t instanceof HazelcastException)) {
                throw ExceptionUtil.rethrow(t);
            }
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Query invocation failed on member ", t);
            }
            return Collections.emptyList();
        }
    }

    private Result populateResult(Query query, BitSet partitionIds) {
        return this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(partitionIds.cardinality()));
    }

    private void doRunQueryOnPartitionThreads(Query query, BitSet partitionIds, Result result) {
        try {
            List<Future<Result>> futures = this.queryDispatcher.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionIds);
            this.addResultsOfPredicate(futures, result, partitionIds, true);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void addResultsOfPredicate(List<Future<Result>> futures, Result result, BitSet finishedPartitionIds, boolean rethrowAll) {
        for (Future<Result> future : futures) {
            Collection<Integer> queriedPartitionIds;
            Result queryResult = null;
            try {
                queryResult = future.get();
            }
            catch (Throwable t) {
                if (t.getCause() instanceof QueryResultSizeExceededException || rethrowAll) {
                    throw ExceptionUtil.rethrow(t);
                }
                this.logger.fine("Could not get query results", t);
            }
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null || !BitSetUtils.hasAllBitsSet(finishedPartitionIds, queriedPartitionIds)) continue;
            BitSetUtils.unsetBits(finishedPartitionIds, queriedPartitionIds);
            result.combine(queryResult);
        }
    }

    private void assertAllPartitionsQueried(BitSet mutablePartitionIds) {
        if (this.isResultFromAnyPartitionMissing(mutablePartitionIds)) {
            throw new QueryException("Query aborted. Could not execute query for all partitions. Missed " + mutablePartitionIds.cardinality() + " partitions");
        }
    }

    private IterationType getRetrievalIterationType(Predicate predicate, IterationType iterationType) {
        IterationType retrievalIterationType = iterationType;
        if (predicate instanceof PagingPredicate) {
            retrievalIterationType = iterationType == IterationType.VALUE ? IterationType.ENTRY : iterationType;
        }
        return retrievalIterationType;
    }

    private BitSet getLocalPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        BitSet partitionIds = new BitSet(partitionCount);
        BitSetUtils.setBits(partitionIds, this.partitionService.getMemberPartitions(this.nodeEngine.getThisAddress()));
        return partitionIds;
    }

    private BitSet getAllPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        BitSet partitionIds = new BitSet(partitionCount);
        partitionIds.set(0, partitionCount, true);
        return partitionIds;
    }

    private boolean isResultFromAnyPartitionMissing(BitSet finishedPartitionIds) {
        return !finishedPartitionIds.isEmpty();
    }

    protected QueryResultSizeLimiter getQueryResultSizeLimiter() {
        return this.queryResultSizeLimiter;
    }
}

