/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.multimap.operations.PutOperation;
import com.hazelcast.multimap.operations.client.MultiMapKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class PutRequest
extends MultiMapKeyBasedRequest
implements InitializingObjectRequest {
    Data value;
    int index = -1;
    int threadId = -1;

    public PutRequest() {
    }

    public PutRequest(String name, Data key, Data value, int index, int threadId) {
        super(name, key);
        this.value = value;
        this.index = index;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new PutOperation(this.name, this.key, this.threadId, this.value, this.index);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("i", this.index);
        writer.writeInt("t", this.threadId);
        super.writePortable(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.value.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.index = reader.readInt("i");
        this.threadId = reader.readInt("t");
        super.readPortable(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "put");
    }
}

