/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.map.EntryEventFilter;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.QueryEventFilter;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.io.IOException;
import java.security.Permission;

public class MapAddEntryListenerRequest
extends CallableClientRequest
implements Portable,
InitializingObjectRequest,
SecureRequest {
    private String name;
    private Data key;
    private Predicate predicate;
    private boolean includeValue;

    public MapAddEntryListenerRequest() {
    }

    public MapAddEntryListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    public MapAddEntryListenerRequest(String name, Data key, boolean includeValue) {
        this(name, includeValue);
        this.key = key;
    }

    public MapAddEntryListenerRequest(String name, Data key, boolean includeValue, Predicate predicate) {
        this(name, key, includeValue);
        this.predicate = predicate;
    }

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        MapService mapService = (MapService)this.getService();
        EntryListener<Object, Object> listener = new EntryListener<Object, Object>(){

            private void handleEvent(EntryEvent<Object, Object> event) {
                if (endpoint.live()) {
                    Data key = clientEngine.toData(event.getKey());
                    Data value = clientEngine.toData(event.getValue());
                    Data oldValue = clientEngine.toData(event.getOldValue());
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, event.getEventType(), event.getMember().getUuid());
                    clientEngine.sendResponse(endpoint, portableEntryEvent);
                }
            }

            @Override
            public void entryAdded(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryRemoved(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryUpdated(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }

            @Override
            public void entryEvicted(EntryEvent<Object, Object> event) {
                this.handleEvent(event);
            }
        };
        EntryEventFilter eventFilter = this.predicate == null ? new EntryEventFilter(this.includeValue, this.key) : new QueryEventFilter(this.includeValue, this.key, this.predicate);
        String registrationId = mapService.addEventListener(listener, eventFilter, this.name);
        endpoint.setListenerRegistration("hz:impl:mapService", this.name, registrationId);
        return true;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeBoolean("i", this.includeValue);
        boolean hasKey = this.key != null;
        writer.writeBoolean("key", hasKey);
        if (this.predicate == null) {
            writer.writeBoolean("pre", false);
        } else {
            writer.writeBoolean("pre", true);
            writer.writePortable("p", (Portable)((Object)this.predicate));
        }
        if (hasKey) {
            ObjectDataOutput out = writer.getRawDataOutput();
            this.key.writeData(out);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.includeValue = reader.readBoolean("i");
        boolean hasKey = reader.readBoolean("key");
        if (reader.readBoolean("pre")) {
            this.predicate = (Predicate)reader.readPortable("p");
        }
        if (hasKey) {
            ObjectDataInput in = reader.getRawDataInput();
            this.key = new Data();
            this.key.readData(in);
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }
}

