/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.PutAllOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultRecordStore
implements RecordStore {
    private final String name;
    private final int partitionId;
    private final ConcurrentMap<Data, Record> records = new ConcurrentHashMap<Data, Record>(1000);
    private final Set<Data> toBeRemovedKeys = new HashSet<Data>();
    private final MapContainer mapContainer;
    private final MapService mapService;
    private final LockStore lockStore;
    private final RecordFactory recordFactory;
    final SizeEstimator sizeEstimator;
    final AtomicBoolean loaded = new AtomicBoolean(false);

    public DefaultRecordStore(String name, MapService mapService, int partitionId) {
        this.name = name;
        this.partitionId = partitionId;
        this.mapService = mapService;
        this.mapContainer = mapService.getMapContainer(name);
        this.recordFactory = this.mapContainer.getRecordFactory();
        NodeEngine nodeEngine = mapService.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, new DefaultObjectNamespace("hz:impl:mapService", name));
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator();
        if (nodeEngine.getThisAddress().equals(nodeEngine.getPartitionService().getPartitionOwner(partitionId))) {
            if (this.mapContainer.getStore() != null && !this.loaded.get()) {
                Map<Data, Object> loadedKeys = this.mapContainer.getInitialKeys();
                if (loadedKeys != null && !loadedKeys.isEmpty()) {
                    HashMap<Data, Object> partitionKeys = new HashMap<Data, Object>();
                    Iterator<Map.Entry<Data, Object>> iterator = loadedKeys.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Data, Object> entry = iterator.next();
                        Data data = entry.getKey();
                        if (partitionId != nodeEngine.getPartitionService().getPartitionId(data)) continue;
                        partitionKeys.put(data, entry.getValue());
                        iterator.remove();
                    }
                    try {
                        nodeEngine.getExecutionService().submit("hz:map-load", new MapLoadAllTask(partitionKeys));
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                } else {
                    this.loaded.set(true);
                }
            }
        } else {
            this.loaded.set(true);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded.get();
    }

    @Override
    public void setLoaded(boolean isLoaded) {
        this.loaded.set(isLoaded);
    }

    private void checkIfLoaded() {
        if (this.mapContainer.getStore() != null && !this.loaded.get()) {
            throw ExceptionUtil.rethrow(new RetryableHazelcastException("Map is not ready!!!"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
        EntryTaskScheduler deleteScheduler;
        this.checkIfLoaded();
        HashSet<Data> keys = new HashSet<Data>();
        for (Record record : this.records.values()) {
            keys.add(record.getKey());
        }
        EntryTaskScheduler writeScheduler = this.mapContainer.getMapStoreWriteScheduler();
        if (writeScheduler != null) {
            Set processedKeys = writeScheduler.flush(keys);
            for (Data key : processedKeys) {
                ((Record)this.records.get(key)).onStore();
            }
        }
        if ((deleteScheduler = this.mapContainer.getMapStoreDeleteScheduler()) != null) {
            deleteScheduler.flush(this.toBeRemovedKeys);
            this.toBeRemovedKeys.clear();
        }
    }

    private void flush(Data key) {
        EntryTaskScheduler deleteScheduler;
        this.checkIfLoaded();
        EntryTaskScheduler writeScheduler = this.mapContainer.getMapStoreWriteScheduler();
        HashSet<Data> keys = new HashSet<Data>(1);
        keys.add(key);
        if (writeScheduler != null) {
            Set processedKeys = writeScheduler.flush(keys);
            for (Data pkey : processedKeys) {
                ((Record)this.records.get(pkey)).onStore();
            }
        }
        if ((deleteScheduler = this.mapContainer.getMapStoreDeleteScheduler()) != null && this.toBeRemovedKeys.contains(key)) {
            deleteScheduler.flush(keys);
            this.toBeRemovedKeys.remove(key);
        }
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.records.get(key);
    }

    @Override
    public void putRecord(Data key, Record record) {
        this.records.put(key, record);
    }

    @Override
    public void deleteRecord(Data key) {
        Record record = (Record)this.records.remove(key);
        if (record != null) {
            record.invalidate();
        }
    }

    @Override
    public Map<Data, Record> getReadonlyRecordMap() {
        return Collections.unmodifiableMap(this.records);
    }

    @Override
    public void clear() {
        IndexService indexService;
        LockService lockService = (LockService)this.mapService.getNodeEngine().getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, new DefaultObjectNamespace("hz:impl:mapService", this.name));
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
    }

    private void clearRecordsMap(Map<Data, Record> excludeRecords) {
        InMemoryFormat inMemoryFormat = this.recordFactory.getStorageFormat();
        switch (inMemoryFormat) {
            case BINARY: 
            case OBJECT: {
                this.records.clear();
                if (excludeRecords != null && !excludeRecords.isEmpty()) {
                    this.records.putAll(excludeRecords);
                }
                return;
            }
            case OFFHEAP: {
                Iterator iter = this.records.values().iterator();
                while (iter.hasNext()) {
                    Record record = (Record)iter.next();
                    if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
                    record.invalidate();
                    iter.remove();
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown storage format: " + (Object)((Object)inMemoryFormat));
    }

    @Override
    public int size() {
        this.checkIfLoaded();
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        for (Record record : this.records.values()) {
            if (!this.mapService.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lock(Data key, String caller, int threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, int threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, int threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, int threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public long getHeapCost() {
        return this.getSizeEstimator().getSize();
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean isLockedBy(Data key, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.isLockedBy(key, caller, threadId);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, int threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Object>> entrySetObject() {
        this.checkIfLoaded();
        HashMap<Data, Object> temp = new HashMap<Data, Object>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toObject(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        this.checkIfLoaded();
        HashMap<Data, Data> temp = new HashMap<Data, Data>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toData(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Map.Entry<Data, Data> getMapEntryData(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Data data = record != null ? this.mapService.toData(record.getValue()) : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, data);
    }

    @Override
    public Map.Entry<Data, Object> getMapEntryObject(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object value = record != null ? this.mapService.toObject(record.getValue()) : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, value);
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        HashSet<Data> keySet = new HashSet<Data>(this.records.size());
        for (Data data : this.records.keySet()) {
            keySet.add(data);
        }
        return keySet;
    }

    @Override
    public Collection<Object> valuesObject() {
        this.checkIfLoaded();
        ArrayList<Object> values = new ArrayList<Object>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toObject(record.getValue()));
        }
        return values;
    }

    @Override
    public Collection<Data> valuesData() {
        this.checkIfLoaded();
        ArrayList<Data> values = new ArrayList<Data>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toData(record.getValue()));
        }
        return values;
    }

    @Override
    public void removeAll() {
        this.checkIfLoaded();
        this.resetSizeEstimator();
        Set<Data> lockedKeys = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        Set keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockedRecords.keySet());
        MapStoreWrapper store = this.mapContainer.getStore();
        HashSet<Object> keysObject = new HashSet<Object>();
        for (Data key : keysToDelete) {
            this.removeIndex(key);
            keysObject.add(this.mapService.toObject(key));
        }
        if (store != null) {
            store.deleteAll(keysObject);
            this.toBeRemovedKeys.clear();
        }
        this.clearRecordsMap(lockedRecords);
    }

    @Override
    public void reset() {
        this.checkIfLoaded();
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
    }

    @Override
    public Object remove(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(null, dataKey);
            }
        } else {
            oldValue = record.getValue();
            if ((oldValue = this.mapService.interceptRemove(this.name, oldValue)) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(record, dataKey);
            }
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(dataKey);
        }
        return oldValue;
    }

    private void removeIndex(Data key) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            indexService.removeEntryIndex(key);
        }
    }

    @Override
    public Object evict(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record != null) {
            this.flush(dataKey);
            this.mapService.interceptRemove(this.name, record.getValue());
            oldValue = record.getValue();
            this.deleteRecord(dataKey);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.removeIndex(dataKey);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Data dataKey, Object testValue) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        boolean removed = false;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
            }
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapService.compare(this.name, testValue, oldValue)) {
            this.mapService.interceptRemove(this.name, oldValue);
            this.removeIndex(dataKey);
            this.mapStoreDelete(record, dataKey);
            this.deleteRecord(dataKey);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            removed = true;
        }
        return removed;
    }

    @Override
    public Object get(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object value = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                int ttlForNull;
                value = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
                if (value != null) {
                    record = this.mapService.createRecord(this.name, dataKey, value, -1L);
                    this.records.put(dataKey, record);
                    this.saveIndex(record);
                    this.updateSizeEstimator(this.calculateRecordSize(record));
                }
                if (value == null && (ttlForNull = this.mapService.getNodeEngine().getGroupProperties().CACHED_NULL_TTL_SECONDS.getInteger()) > 0) {
                    record = this.mapService.createRecord(this.name, dataKey, null, ttlForNull * 1000);
                    this.records.put(dataKey, record);
                    this.updateSizeEstimator(this.calculateRecordSize(record));
                }
            }
        } else {
            this.accessRecord(record);
            value = record.getValue();
        }
        value = this.mapService.interceptGet(this.name, value);
        return value;
    }

    @Override
    public MapEntrySet getAll(Set<Data> keySet) {
        this.checkIfLoaded();
        MapEntrySet mapEntrySet = new MapEntrySet();
        HashMap<Object, Data> keyMapForLoader = null;
        if (this.mapContainer.getStore() != null) {
            keyMapForLoader = new HashMap<Object, Data>();
        }
        for (Data dataKey : keySet) {
            Record record = (Record)this.records.get(dataKey);
            if (record == null) {
                if (this.mapContainer.getStore() == null) continue;
                keyMapForLoader.put(this.mapService.toObject(dataKey), dataKey);
                continue;
            }
            this.accessRecord(record);
            Object value = record.getValue();
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        if (this.mapContainer.getStore() == null || keyMapForLoader.size() == 0) {
            return mapEntrySet;
        }
        Map loadedKeys = this.mapContainer.getStore().loadAll((Collection)keyMapForLoader.keySet());
        for (Map.Entry entry : loadedKeys.entrySet()) {
            Object objectKey = entry.getKey();
            Object value = entry.getValue();
            Data dataKey = (Data)keyMapForLoader.get(objectKey);
            if (value != null) {
                Record record = this.mapService.createRecord(this.name, dataKey, value, -1L);
                this.records.put(dataKey, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            } else {
                int ttlForNull = this.mapService.getNodeEngine().getGroupProperties().CACHED_NULL_TTL_SECONDS.getInteger();
                if (ttlForNull > 0) {
                    Record record = this.mapService.createRecord(this.name, dataKey, null, ttlForNull * 1000);
                    this.records.put(dataKey, record);
                    this.updateSizeEstimator(this.calculateRecordSize(record));
                }
            }
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        return mapEntrySet;
    }

    @Override
    public boolean containsKey(Data dataKey) {
        boolean contains;
        Object value;
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null && this.mapContainer.getStore() != null && (value = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
            record = this.mapService.createRecord(this.name, dataKey, value, -1L);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        boolean bl = contains = record != null && record.getValue() != null;
        if (contains) {
            this.accessRecord(record);
        }
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        this.checkIfLoaded();
        Data dataKey = entry.getKey();
        Object value = entry.getValue();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, -1L);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            Object oldValue = record.getValue();
            if (this.mapService.compare(this.name, oldValue, value = this.mapService.interceptPut(this.name, oldValue, value))) {
                this.accessRecord(record);
            } else {
                this.mapStoreWrite(record, dataKey, value);
                this.updateSizeEstimator(-this.calculateRecordSize(record));
                this.setRecordValue(record, value);
                this.updateSizeEstimator(this.calculateRecordSize(record));
                this.saveIndex(record);
            }
        }
    }

    @Override
    public Object put(Data dataKey, Object value, long ttl) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
            }
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            oldValue = record.getValue();
            if (this.mapService.compare(this.name, oldValue, value = this.mapService.interceptPut(this.name, oldValue, value))) {
                this.accessRecord(record);
                this.updateTtl(record, ttl);
            } else {
                this.mapStoreWrite(record, dataKey, value);
                this.updateSizeEstimator(-this.calculateRecordSize(record));
                this.setRecordValue(record, value);
                this.updateSizeEstimator(this.calculateRecordSize(record));
                this.updateTtl(record, ttl);
                this.saveIndex(record);
            }
        }
        return oldValue;
    }

    @Override
    public boolean set(Data dataKey, Object value, long ttl) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            newRecord = true;
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.mapStoreWrite(record, dataKey, value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return newRecord;
    }

    @Override
    public boolean merge(Data dataKey, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object newValue = null;
        if (record == null) {
            newValue = mergingEntry.getValue();
            record = this.mapService.createRecord(this.name, dataKey, newValue, -1L);
            this.mapStoreWrite(record, dataKey, newValue);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            Object oldValue = record.getValue();
            SimpleEntryView<Object, Object> existingEntry = new SimpleEntryView<Object, Object>(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()), record.getStatistics(), record.getVersion());
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.deleteRecord(dataKey);
                this.removeIndex(dataKey);
                this.mapStoreDelete(record, dataKey);
                this.updateSizeEstimator(-this.calculateRecordSize(record));
                return true;
            }
            if (this.mapService.compare(this.name, newValue, oldValue)) {
                return true;
            }
            this.mapStoreWrite(record, dataKey, newValue);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.recordFactory.setValue(record, newValue);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data dataKey, Object value) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            return null;
        }
        oldValue = record.getValue();
        value = this.mapService.interceptPut(this.name, oldValue, value);
        this.mapStoreWrite(record, dataKey, value);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, value);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data dataKey, Object testValue, Object newValue) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            return false;
        }
        if (!this.mapService.compare(this.name, record.getValue(), testValue)) {
            return false;
        }
        newValue = this.mapService.interceptPut(this.name, record.getValue(), newValue);
        this.mapStoreWrite(record, dataKey, newValue);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, newValue);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data dataKey, Object value, long ttl) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
    }

    @Override
    public void putFromLoad(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
    }

    @Override
    public boolean tryPut(Data dataKey, Object value, long ttl) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.mapStoreWrite(record, dataKey, value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return true;
    }

    @Override
    public Object putIfAbsent(Data dataKey, Object value, long ttl) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
                record = this.mapService.createRecord(this.name, dataKey, oldValue, -1L);
                this.records.put(dataKey, record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
        } else {
            this.accessRecord(record);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return oldValue;
    }

    private void accessRecord(Record record) {
        record.onAccess();
        int maxIdleSeconds = this.mapContainer.getMapConfig().getMaxIdleSeconds();
        if (maxIdleSeconds > 0) {
            this.mapService.scheduleIdleEviction(this.name, record.getKey(), TimeUnit.SECONDS.toMillis(maxIdleSeconds));
        }
    }

    private void saveIndex(Record record) {
        Data dataKey = record.getKey();
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            SerializationService ss = this.mapService.getSerializationService();
            QueryEntry queryableEntry = new QueryEntry(ss, dataKey, dataKey, record.getValue());
            indexService.saveEntryIndex(queryableEntry);
        }
    }

    private void mapStoreWrite(Record record, Data key, Object value) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
            if (writeDelayMillis <= 0L) {
                store.store(this.mapService.toObject(key), this.mapService.toObject(value));
                if (record != null) {
                    record.onStore();
                }
            } else {
                this.mapService.scheduleMapStoreWrite(this.name, key, value, writeDelayMillis);
            }
        }
    }

    private void mapStoreDelete(Record record, Data key) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
            if (writeDelayMillis == 0L) {
                store.delete(this.mapService.toObject(key));
                if (record != null) {
                    record.onStore();
                }
            } else {
                this.mapService.scheduleMapStoreDelete(this.name, key, writeDelayMillis);
                this.toBeRemovedKeys.add(key);
            }
        }
    }

    @Override
    public SizeEstimator getSizeEstimator() {
        return this.sizeEstimator;
    }

    private void updateTtl(Record record, long ttl) {
        if (ttl > 0L) {
            this.mapService.scheduleTtlEviction(this.name, record, ttl);
        } else if (ttl == 0L) {
            this.mapContainer.getTtlEvictionScheduler().cancel(record.getKey());
        }
    }

    private void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    private long calculateRecordSize(Record record) {
        return this.sizeEstimator.getCost(record);
    }

    private void resetSizeEstimator() {
        this.sizeEstimator.reset();
    }

    private void setRecordValue(Record record, Object value) {
        this.accessRecord(record);
        record.onUpdate();
        this.recordFactory.setValue(record, value);
    }

    private class MapLoadAllTask
    implements Runnable {
        private Map<Data, Object> keys;

        private MapLoadAllTask(Map<Data, Object> keys) {
            this.keys = keys;
        }

        @Override
        public void run() {
            final NodeEngine nodeEngine = DefaultRecordStore.this.mapService.getNodeEngine();
            Map values = DefaultRecordStore.this.mapContainer.getStore().loadAll(this.keys.values());
            MapEntrySet entrySet = new MapEntrySet();
            for (Data dataKey : this.keys.keySet()) {
                Object key = this.keys.get(dataKey);
                Data dataValue = DefaultRecordStore.this.mapService.toData(values.get(key));
                entrySet.add(dataKey, dataValue);
            }
            PutAllOperation operation = new PutAllOperation(DefaultRecordStore.this.name, entrySet, true);
            operation.setNodeEngine(nodeEngine);
            operation.setResponseHandler(new ResponseHandler(){

                @Override
                public void sendResponse(Object obj) {
                    if (!(obj instanceof Exception)) {
                        DefaultRecordStore.this.loaded.set(true);
                    } else {
                        Exception e = (Exception)obj;
                        nodeEngine.getLogger(RecordStore.class).finest(e.getMessage());
                    }
                }

                @Override
                public boolean isLocal() {
                    return true;
                }
            });
            operation.setPartitionId(DefaultRecordStore.this.partitionId);
            OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
            operation.setServiceName("hz:impl:mapService");
            nodeEngine.getOperationService().executeOperation(operation);
        }
    }
}

