/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MemberInfo
implements DataSerializable {
    Address address = null;
    String uuid;

    public MemberInfo() {
    }

    public MemberInfo(Address address) {
        this.address = address;
    }

    public MemberInfo(Address address, String uuid) {
        this.address = address;
        this.uuid = uuid;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        if (in.readBoolean()) {
            this.uuid = in.readUTF();
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        boolean hasUuid = this.uuid != null;
        out.writeBoolean(hasUuid);
        if (hasUuid) {
            out.writeUTF(this.uuid);
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String toString() {
        return "MemberInfo{address=" + this.address + '}';
    }
}

