/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.impl.Response;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public final class PartitionIteratingOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private List<Integer> partitions;
    private OperationFactory operationFactory;
    private transient Map<Integer, Object> results;

    public PartitionIteratingOperation(List<Integer> partitions, OperationFactory operationFactory) {
        this.partitions = partitions != null ? partitions : Collections.emptyList();
        this.operationFactory = operationFactory;
    }

    public PartitionIteratingOperation() {
    }

    @Override
    public final void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.results = new HashMap<Integer, Object>(this.partitions.size());
        try {
            HashMap<Integer, ResponseQueue> responses = new HashMap<Integer, ResponseQueue>(this.partitions.size());
            Iterator<Object> iterator = this.partitions.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                ResponseQueue responseQueue = new ResponseQueue();
                Operation op = this.operationFactory.createOperation();
                op.setNodeEngine(nodeEngine).setPartitionId(n).setReplicaIndex(this.getReplicaIndex()).setResponseHandler(responseQueue).setServiceName(this.getServiceName()).setService(this.getService());
                OperationAccessor.setCallerAddress(op, this.getCallerAddress());
                responses.put(n, responseQueue);
                nodeEngine.getOperationService().executeOperation(op);
            }
            for (Map.Entry entry : responses.entrySet()) {
                ResponseQueue queue = (ResponseQueue)entry.getValue();
                Integer key = (Integer)entry.getKey();
                Object result = queue.get();
                if (result instanceof Response) {
                    this.results.put(key, ((Response)result).response);
                    continue;
                }
                this.results.put(key, result);
            }
        }
        catch (Exception e) {
            this.getLogger(nodeEngine).severe(e);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    private ILogger getLogger(NodeEngine nodeEngine) {
        return nodeEngine.getLogger(PartitionIteratingOperation.class.getName());
    }

    @Override
    public final Object getResponse() {
        return new PartitionResponse(this.results);
    }

    @Override
    public final boolean returnsResponse() {
        return true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int pCount = this.partitions.size();
        out.writeInt(pCount);
        for (int i = 0; i < pCount; ++i) {
            out.writeInt(this.partitions.get(i));
        }
        out.writeObject(this.operationFactory);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int pCount = in.readInt();
        this.partitions = new ArrayList<Integer>(pCount);
        for (int i = 0; i < pCount; ++i) {
            this.partitions.add(in.readInt());
        }
        this.operationFactory = (OperationFactory)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    public static final class PartitionResponse
    implements IdentifiedDataSerializable {
        private Map<Integer, Object> results;

        public PartitionResponse() {
        }

        public PartitionResponse(Map<Integer, Object> results) {
            this.results = results != null ? results : Collections.emptyMap();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            int len = this.results != null ? this.results.size() : 0;
            out.writeInt(len);
            if (len > 0) {
                for (Map.Entry<Integer, Object> entry : this.results.entrySet()) {
                    out.writeInt(entry.getKey());
                    out.writeObject(entry.getValue());
                }
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int len = in.readInt();
            if (len > 0) {
                this.results = new HashMap<Integer, Object>(len);
                for (int i = 0; i < len; ++i) {
                    int pid = in.readInt();
                    Object value = in.readObject();
                    this.results.put(pid, value);
                }
            } else {
                this.results = Collections.emptyMap();
            }
        }

        public Map<? extends Integer, ?> asMap() {
            return this.results;
        }

        @Override
        public int getFactoryId() {
            return SpiDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 4;
        }
    }

    private class ResponseQueue
    implements ResponseHandler {
        final BlockingQueue b = ResponseQueueFactory.newResponseQueue();

        private ResponseQueue() {
        }

        @Override
        public void sendResponse(Object obj) {
            this.b.offer(obj);
        }

        public Object get() throws InterruptedException {
            return this.b.take();
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

