/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public class ReplicaSyncResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation {
    private byte[] data;
    private long[] replicaVersions;
    private boolean compressed;

    public ReplicaSyncResponse() {
    }

    public ReplicaSyncResponse(byte[] data, long[] replicaVersions, boolean compressed) {
        this.data = data;
        this.replicaVersions = replicaVersions;
        this.compressed = compressed;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        SerializationService serializationService = nodeEngine.getSerializationService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        BufferObjectDataInput in = null;
        try {
            if (this.data != null && this.data.length > 0) {
                this.logApplyReplicaSync(partitionId, replicaIndex);
                byte[] taskData = this.compressed ? IOUtil.decompress(this.data) : this.data;
                in = serializationService.createObjectDataInput(taskData);
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Operation op = (Operation)serializationService.readObject(in);
                    try {
                        ErrorLoggingResponseHandler responseHandler = new ErrorLoggingResponseHandler(nodeEngine.getLogger(op.getClass()));
                        op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex).setResponseHandler(responseHandler);
                        op.beforeRun();
                        op.run();
                        op.afterRun();
                        continue;
                    }
                    catch (Throwable e) {
                        this.logException(op, e);
                    }
                }
            }
        }
        finally {
            IOUtil.closeResource(in);
            partitionService.finalizeReplicaSync(partitionId, this.replicaVersions);
        }
    }

    private void logException(Operation op, Throwable e) {
        Level level;
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(this.getClass());
        Level level2 = level = nodeEngine.isActive() ? Level.WARNING : Level.FINEST;
        if (logger.isLoggable(level)) {
            logger.log(level, "While executing " + op, e);
        }
    }

    private void logApplyReplicaSync(int partitionId, int replicaIndex) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(this.getClass());
        if (logger.isFinestEnabled()) {
            logger.finest("Applying replica sync for partition: " + partitionId + ", replica: " + replicaIndex);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return true;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        IOUtil.writeByteArray(out, this.data);
        out.writeLongArray(this.replicaVersions);
        out.writeBoolean(this.compressed);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.data = IOUtil.readByteArray(in);
        this.replicaVersions = in.readLongArray();
        this.compressed = in.readBoolean();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncResponse");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append('}');
        return sb.toString();
    }

    private static final class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

