/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.SocketClientDataWriter;
import com.hazelcast.nio.SocketPacketWriter;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.util.Clock;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer buffer;
    private final IOSelector ioSelector;
    private boolean ready = false;
    private SocketWritable lastWritable;
    private SocketWriter socketWriter;
    private volatile long lastHandle = 0L;

    WriteHandler(TcpIpConnection connection, IOSelector ioSelector) {
        super(connection);
        this.ioSelector = ioSelector;
        this.buffer = ByteBuffer.allocate(this.connectionManager.socketSendBufferSize);
    }

    void setProtocol(final String protocol) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.ioSelector.addTask(new Runnable(){

            @Override
            public void run() {
                WriteHandler.this.createWriter(protocol);
                latch.countDown();
            }
        });
        this.ioSelector.wakeup();
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void createWriter(String protocol) {
        if (this.socketWriter == null) {
            if ("HZC".equals(protocol)) {
                this.socketWriter = new SocketPacketWriter(this.connection);
                this.buffer.put("HZC".getBytes());
                this.registerWrite();
            } else {
                this.socketWriter = "CB1".equals(protocol) ? new SocketClientDataWriter(this.connection) : new SocketTextWriter(this.connection);
            }
        }
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        socketWritable.onEnqueue();
        this.writeQueue.offer(socketWritable);
        if (this.informSelector.compareAndSet(true, false)) {
            this.ioSelector.addTask(this);
            this.ioSelector.wakeup();
        }
    }

    private SocketWritable poll() {
        return this.writeQueue.poll();
    }

    @Override
    public void handle() {
        block14: {
            this.lastHandle = Clock.currentTimeMillis();
            if (!this.connection.live()) {
                return;
            }
            if (this.socketWriter == null) {
                this.logger.log(Level.WARNING, "SocketWriter is not set, creating SocketWriter with CLUSTER protocol!");
                this.createWriter("HZC");
            }
            if (this.lastWritable == null && (this.lastWritable = this.poll()) == null && this.buffer.position() == 0) {
                this.ready = true;
                return;
            }
            try {
                boolean complete;
                while (this.buffer.hasRemaining() && this.lastWritable != null && (complete = this.socketWriter.write(this.lastWritable, this.buffer))) {
                    this.lastWritable = this.poll();
                }
                if (this.buffer.position() <= 0) break block14;
                this.buffer.flip();
                try {
                    this.socketChannel.write(this.buffer);
                }
                catch (Exception e) {
                    this.lastWritable = null;
                    this.handleSocketException(e);
                    this.ready = false;
                    this.registerWrite();
                    return;
                }
                if (this.buffer.hasRemaining()) {
                    this.buffer.compact();
                } else {
                    this.buffer.clear();
                }
            }
            catch (Throwable t) {
                this.logger.severe("Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
                this.connection.getSystemLogService().logConnection("Fatal Error at WriteHandler for endPoint [" + this.connection.getEndPoint() + "]: " + t.getMessage());
            }
            finally {
                this.ready = false;
                this.registerWrite();
            }
        }
    }

    @Override
    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.registerOp(this.ioSelector.getSelector(), 4);
    }

    @Override
    public void shutdown() {
        while (this.poll() != null) {
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

