/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.IOService;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

abstract class AbstractIOSelector
extends Thread
implements IOSelector {
    protected final ILogger logger;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final IOService ioService;
    protected final int waitTime;
    protected final Selector selector;
    protected boolean live = true;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    protected AbstractIOSelector(IOService ioService, String tname) {
        super(ioService.getThreadGroup(), tname);
        this.ioService = ioService;
        this.logger = ioService.getLogger(this.getClass().getName());
        this.waitTime = 5000;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
    }

    @Override
    public final void shutdown() {
        this.selectorQueue.clear();
        try {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    AbstractIOSelector.this.live = false;
                    AbstractIOSelector.this.shutdownLatch.countDown();
                }
            });
            this.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public final void awaitShutdown() {
        try {
            this.shutdownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public final void addTask(Runnable runnable) {
        this.selectorQueue.add(runnable);
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        try {
            block22: while (true) {
                if (!this.live) break;
                this.processSelectionQueue();
                if (!this.live || this.isInterrupted()) {
                    this.logger.finest(this.getName() + " is interrupted!");
                    this.live = false;
                    return;
                }
                try {
                    selectedKeyCount = this.selector.select(this.waitTime);
                }
                catch (Throwable e) {
                    this.logger.warning(e.toString());
                    continue;
                }
                if (selectedKeyCount == 0) continue;
                setSelectedKeys = this.selector.selectedKeys();
                it = setSelectedKeys.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block22;
                    sk = it.next();
                    try {
                        it.remove();
                        this.handleSelectionKey(sk);
                    }
                    catch (Throwable e) {
                        this.handleSelectorException(e);
                    }
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            this.ioService.onOutOfMemory(e);
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            try {
                this.logger.finest("Closing selector " + this.getName());
                this.selector.close();
            }
            catch (Exception e) {}
        }
    }

    protected abstract void handleSelectionKey(SelectionKey var1);

    private void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + this.getName() + ", cause= " + e.toString();
        this.logger.warning(msg, e);
        if (e instanceof OutOfMemoryError) {
            this.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void wakeup() {
        this.selector.wakeup();
    }
}

