/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.txn;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.multimap.operations.MultiMapKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class TxnRemoveAllOperation
extends MultiMapKeyBasedOperation {
    Collection<Long> recordIds;
    transient long begin = -1L;
    transient Collection<MultiMapRecord> removed;

    public TxnRemoveAllOperation() {
    }

    public TxnRemoveAllOperation(String name, Data dataKey, Collection<MultiMapRecord> records) {
        super(name, dataKey);
        this.recordIds = new ArrayList<Long>();
        for (MultiMapRecord record : records) {
            this.recordIds.add(record.getRecordId());
        }
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapWrapper wrapper = container.getOrCreateMultiMapWrapper(this.dataKey);
        this.response = true;
        for (Long recordId : this.recordIds) {
            if (wrapper.containsRecordId(recordId)) continue;
            this.response = false;
            return;
        }
        Collection<MultiMapRecord> coll = wrapper.getCollection(false);
        this.removed = new LinkedList<MultiMapRecord>();
        block1: for (Long recordId : this.recordIds) {
            Iterator<MultiMapRecord> iter = coll.iterator();
            while (iter.hasNext()) {
                MultiMapRecord record = iter.next();
                if (record.getRecordId() != recordId.longValue()) continue;
                iter.remove();
                this.removed.add(record);
                continue block1;
            }
        }
        if (coll.isEmpty()) {
            this.delete();
        }
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        MultiMapService service = (MultiMapService)this.getService();
        service.getLocalMultiMapStatsImpl(this.name).incrementRemoves(elapsed);
        if (this.removed != null) {
            this.getOrCreateContainer().update();
            for (MultiMapRecord record : this.removed) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, record.getObject());
            }
        }
    }

    public Collection<Long> getRecordIds() {
        return this.recordIds;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.recordIds.size());
        for (Long recordId : this.recordIds) {
            out.writeLong(recordId);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.recordIds = new ArrayList<Long>();
        for (int i = 0; i < size; ++i) {
            this.recordIds.add(in.readLong());
        }
    }

    @Override
    public int getId() {
        return 34;
    }
}

