/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.CallableTaskOperation;
import com.hazelcast.executor.CancellableDelegatingFuture;
import com.hazelcast.executor.DistributedExecutorService;
import com.hazelcast.executor.ExecutionCallbackAdapter;
import com.hazelcast.executor.ExecutionCallbackAdapterFactory;
import com.hazelcast.executor.MemberCallableTaskOperation;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.ShutdownOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceProxy
extends AbstractDistributedObject<DistributedExecutorService>
implements IExecutorService {
    private final String name;
    private final Random random = new Random();
    private final int partitionCount;
    private final AtomicInteger consecutiveSubmits = new AtomicInteger();
    private volatile long lastSubmitTime = 0L;

    public ExecutorServiceProxy(String name, NodeEngine nodeEngine, DistributedExecutorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
    }

    @Override
    public void execute(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submit(callable);
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    @Override
    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner(callable, key);
    }

    @Override
    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember(callable, member);
    }

    @Override
    public void executeOnMembers(Runnable command, Collection<Member> members) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMembers(callable, members);
    }

    @Override
    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToAllMembers(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submit(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        RunnableAdapter<T> callable = this.createRunnableAdapter(task);
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UUID.randomUUID().toString();
        int partitionId = this.getTaskPartitionId(callable);
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)new CallableTaskOperation(this.name, uuid, callable), partitionId).build();
        Future future = inv.invoke();
        boolean sync = this.checkSync();
        if (sync) {
            try {
                future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), result);
        }
        return new CancellableDelegatingFuture<T>(future, result, nodeEngine, uuid, partitionId);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        int partitionId = this.getTaskPartitionId(task);
        return this.submitToPartitionOwner(task, partitionId);
    }

    private <T> Future<T> submitToPartitionOwner(Callable<T> task, int partitionId) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UUID.randomUUID().toString();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)new CallableTaskOperation(this.name, uuid, task), partitionId).build();
        boolean sync = this.checkSync();
        Future future = inv.invoke();
        if (sync) {
            Object response;
            try {
                response = future.get();
            }
            catch (Exception e) {
                response = e;
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), response);
        }
        return new CancellableDelegatingFuture(future, nodeEngine, uuid, partitionId);
    }

    private boolean checkSync() {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            this.consecutiveSubmits.set(0);
        } else if (this.consecutiveSubmits.incrementAndGet() % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        return sync;
    }

    private <T> int getTaskPartitionId(Callable<T> task) {
        int partitionId;
        if (task instanceof PartitionAware) {
            Object partitionKey = ((PartitionAware)((Object)task)).getPartitionKey();
            partitionId = this.getNodeEngine().getPartitionService().getPartitionId(partitionKey);
        } else {
            partitionId = this.random.nextInt(this.partitionCount);
        }
        return partitionId;
    }

    @Override
    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToPartitionOwner(task, nodeEngine.getPartitionService().getPartitionId(key));
    }

    @Override
    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UUID.randomUUID().toString();
        Address target = ((MemberImpl)member).getAddress();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)new MemberCallableTaskOperation(this.name, uuid, task), target).build();
        boolean sync = this.checkSync();
        Future future = inv.invoke();
        if (sync) {
            Object response;
            try {
                response = future.get();
            }
            catch (Exception e) {
                response = e;
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), response);
        }
        return new CancellableDelegatingFuture(future, nodeEngine, uuid, target);
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futures = new HashMap<Member, Future<T>>(members.size());
        for (Member member : members) {
            futures.put(member, this.submitToMember(task, member));
        }
        return futures;
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToMembers(task, nodeEngine.getClusterService().getMembers());
    }

    @Override
    public void submit(Runnable task, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submit(callable, callback);
    }

    @Override
    public void submitToKeyOwner(Runnable task, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToKeyOwner(callable, key, callback);
    }

    @Override
    public void submitToMember(Runnable task, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMember(callable, member, callback);
    }

    @Override
    public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMembers(callable, members, callback);
    }

    @Override
    public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToAllMembers(callable, callback);
    }

    private <T> void submitToPartitionOwner(Callable<T> task, ExecutionCallback<T> callback, int partitionId) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)new CallableTaskOperation(this.name, null, task), partitionId).setCallback(new ExecutionCallbackAdapter(callback)).build();
        inv.invoke();
    }

    @Override
    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        int partitionId = this.getTaskPartitionId(task);
        this.submitToPartitionOwner(task, callback, partitionId);
    }

    @Override
    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToPartitionOwner(task, callback, nodeEngine.getPartitionService().getPartitionId(key));
    }

    @Override
    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)new MemberCallableTaskOperation(this.name, null, task), ((MemberImpl)member).getAddress()).setCallback(new ExecutionCallbackAdapter(callback)).build();
        inv.invoke();
    }

    private String getRejectionMessage() {
        return "ExecutorService[" + this.name + "] is shutdown! In order to create a new ExecutorService with name '" + this.name + "', you need to destroy current ExecutorService first!";
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        ExecutionCallbackAdapterFactory executionCallbackFactory = new ExecutionCallbackAdapterFactory(nodeEngine, members, callback);
        for (Member member : members) {
            this.submitToMember(task, member, executionCallbackFactory.callbackFor(member));
        }
    }

    @Override
    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToMembers(task, nodeEngine.getClusterService().getMembers(), callback);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            futures.add(this.submit(callable));
        }
        for (Future future : futures) {
            Object value;
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                value = e;
            }
            result.add(new CompletedFuture(this.getNodeEngine().getSerializationService(), value));
        }
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RuntimeException throwNotActiveException() {
        throw new RejectedExecutionException();
    }

    @Override
    public boolean isShutdown() {
        try {
            return ((DistributedExecutorService)this.getService()).isShutdown(this.name);
        }
        catch (HazelcastInstanceNotActiveException e) {
            return true;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void shutdown() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        OperationService operationService = nodeEngine.getOperationService();
        LinkedList<Future> calls = new LinkedList<Future>();
        for (MemberImpl member : members) {
            if (member.localMember()) {
                ((DistributedExecutorService)this.getService()).shutdownExecutor(this.name);
                continue;
            }
            Future f = operationService.createInvocationBuilder(this.getServiceName(), (Operation)new ShutdownOperation(this.name), member.getAddress()).build().invoke();
            calls.add(f);
        }
        for (Future f : calls) {
            try {
                f.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        return ((DistributedExecutorService)this.getService()).getLocalExecutorStats(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IExecutorService{");
        sb.append("name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

