/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ValidationUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    private static final ILogger logger = Logger.getLogger(ConfigXmlGenerator.class);
    private final boolean formatted;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    public String generate(Config config) {
        String clazz;
        ValidationUtil.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-3.1.xsd\">");
        xml.append("<group>");
        xml.append("<name>").append(config.getGroupConfig().getName()).append("</name>");
        xml.append("<password>").append(config.getGroupConfig().getPassword()).append("</password>");
        xml.append("</group>");
        if (config.getLicenseKey() != null) {
            xml.append("<license-key>").append(config.getLicenseKey()).append("</license-key>");
        }
        if (config.getManagementCenterConfig() != null) {
            ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
            xml.append("<management-center enabled=\"").append(mcConfig.isEnabled()).append("\" update-interval=\"").append(mcConfig.getUpdateInterval()).append("\">").append(mcConfig.getUrl()).append("</management-center>");
        }
        this.appendProperties(xml, config.getProperties());
        Collection<WanReplicationConfig> wanRepConfigs = config.getWanReplicationConfigs().values();
        for (WanReplicationConfig wan : wanRepConfigs) {
            xml.append("<wan-replication name=\"").append(wan.getName()).append("\">");
            List<WanTargetClusterConfig> targets = wan.getTargetClusterConfigs();
            for (WanTargetClusterConfig t : targets) {
                xml.append("<target-cluster group-name=\"").append(t.getGroupName()).append("\" group-password=\"").append(t.getGroupPassword()).append("\">");
                xml.append("<replication-impl>").append(t.getReplicationImpl()).append("</replication-impl>");
                xml.append("<end-points>");
                List<String> eps = t.getEndpoints();
                Iterator<String> iterator = eps.iterator();
                while (iterator.hasNext()) {
                    String ep = iterator.next();
                    xml.append("<address>").append(ep).append("</address>");
                }
                xml.append("</end-points>").append("</target-cluster>");
            }
            xml.append("</wan-replication>");
        }
        NetworkConfig netCfg = config.getNetworkConfig();
        xml.append("<network>");
        if (netCfg.getPublicAddress() != null) {
            xml.append("<public-address>").append(netCfg.getPublicAddress()).append("</public-address>");
        }
        xml.append("<port port-count=\"").append(netCfg.getPortCount()).append("\" ").append("auto-increment=\"").append(netCfg.isPortAutoIncrement()).append("\">").append(netCfg.getPort()).append("</port>");
        JoinConfig join = netCfg.getJoin();
        xml.append("<join>");
        MulticastConfig mcast = join.getMulticastConfig();
        xml.append("<multicast enabled=\"").append(mcast.isEnabled()).append("\">");
        xml.append("<multicast-group>").append(mcast.getMulticastGroup()).append("</multicast-group>");
        xml.append("<multicast-port>").append(mcast.getMulticastPort()).append("</multicast-port>");
        xml.append("<multicast-timeout-seconds>").append(mcast.getMulticastTimeoutSeconds()).append("</multicast-timeout-seconds>");
        xml.append("<multicast-time-to-live>").append(mcast.getMulticastTimeToLive()).append("</multicast-time-to-live>");
        if (!mcast.getTrustedInterfaces().isEmpty()) {
            xml.append("<trusted-interfaces>");
            for (String trustedInterface : mcast.getTrustedInterfaces()) {
                xml.append("<interface>").append(trustedInterface).append("</interface>");
            }
            xml.append("</trusted-interfaces>");
        }
        xml.append("</multicast>");
        TcpIpConfig tcpCfg = join.getTcpIpConfig();
        xml.append("<tcp-ip enabled=\"").append(tcpCfg.isEnabled()).append("\">");
        List<String> members = tcpCfg.getMembers();
        for (String m : members) {
            xml.append("<member>").append(m).append("</member>");
        }
        if (tcpCfg.getRequiredMember() != null) {
            xml.append("<required-member>").append(tcpCfg.getRequiredMember()).append("</required-member>");
        }
        xml.append("</tcp-ip>");
        AwsConfig awsConfig = join.getAwsConfig();
        xml.append("<aws enabled=\"").append(awsConfig.isEnabled()).append("\">");
        xml.append("<access-key>").append(awsConfig.getAccessKey()).append("</access-key>");
        xml.append("<secret-key>").append(awsConfig.getSecretKey()).append("</secret-key>");
        xml.append("<region>").append(awsConfig.getRegion()).append("</region>");
        xml.append("<security-group-name>").append(awsConfig.getSecurityGroupName()).append("</security-group-name>");
        xml.append("<tag-key>").append(awsConfig.getTagKey()).append("</tag-key>");
        xml.append("<tag-value>").append(awsConfig.getTagValue()).append("</tag-value>");
        xml.append("</aws>");
        xml.append("</join>");
        InterfacesConfig interfaces = netCfg.getInterfaces();
        xml.append("<interfaces enabled=\"").append(interfaces.isEnabled()).append("\">");
        Collection<String> interfaceList = interfaces.getInterfaces();
        for (String i : interfaceList) {
            xml.append("<interface>").append(i).append("</interface>");
        }
        xml.append("</interfaces>");
        SSLConfig ssl = netCfg.getSSLConfig();
        xml.append("<ssl enabled=\"").append(ssl != null && ssl.isEnabled()).append("\">");
        if (ssl != null) {
            String className = ssl.getFactoryImplementation() != null ? ssl.getFactoryImplementation().getClass().getName() : ssl.getFactoryClassName();
            xml.append("<factory-class-name>").append(className).append("</factory-class-name>");
            this.appendProperties(xml, ssl.getProperties());
        }
        xml.append("</ssl>");
        SocketInterceptorConfig socket = netCfg.getSocketInterceptorConfig();
        xml.append("<socket-interceptor enabled=\"").append(socket != null && socket.isEnabled()).append("\">");
        if (socket != null) {
            String className = socket.getImplementation() != null ? socket.getImplementation().getClass().getName() : socket.getClassName();
            xml.append("<class-name>").append(className).append("</class-name>");
            this.appendProperties(xml, socket.getProperties());
        }
        xml.append("</socket-interceptor>");
        SymmetricEncryptionConfig sec = netCfg.getSymmetricEncryptionConfig();
        xml.append("<symmetric-encryption enabled=\"").append(sec != null && sec.isEnabled()).append("\">");
        if (sec != null) {
            xml.append("<algorithm>").append(sec.getAlgorithm()).append("</algorithm>");
            xml.append("<salt>").append(sec.getSalt()).append("</salt>");
            xml.append("<password>").append(sec.getPassword()).append("</password>");
            xml.append("<iteration-count>").append(sec.getIterationCount()).append("</iteration-count>");
        }
        xml.append("</symmetric-encryption>");
        xml.append("</network>");
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg != null) {
            xml.append("<partition-group enabled=\"").append(pg.isEnabled()).append("\" group-type=\"").append((Object)pg.getGroupType()).append("\" />");
        }
        Collection<ExecutorConfig> exCfgs = config.getExecutorConfigs().values();
        for (ExecutorConfig executorConfig : exCfgs) {
            xml.append("<executor-service name=\"").append(executorConfig.getName()).append("\">");
            xml.append("<pool-size>").append(executorConfig.getPoolSize()).append("</pool-size>");
            xml.append("<queue-capacity>").append(executorConfig.getQueueCapacity()).append("</queue-capacity>");
            xml.append("</executor-service>");
        }
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig queueConfig : qCfgs) {
            xml.append("<queue name=\"").append(queueConfig.getName()).append("\">");
            xml.append("<queue-max-size>").append(queueConfig.getMaxSize()).append("</queue-max-size>");
            xml.append("<queue-sync-backup-count>").append(queueConfig.getBackupCount()).append("</queue-sync-backup-count>");
            xml.append("<queue-async-backup-count>").append(queueConfig.getAsyncBackupCount()).append("</queue-async-backup-count>");
            if (!queueConfig.getItemListenerConfigs().isEmpty()) {
                xml.append("<item-listeners>");
                for (ItemListenerConfig itemListenerConfig : queueConfig.getItemListenerConfigs()) {
                    xml.append("<item-listener include-value=\"").append(itemListenerConfig.isIncludeValue()).append("\">");
                    xml.append(itemListenerConfig.getClassName());
                    xml.append("</item-listener>");
                }
                xml.append("</item-listeners>");
            }
            xml.append("</queue>");
        }
        Collection<MapConfig> collection = config.getMapConfigs().values();
        for (MapConfig mapConfig : collection) {
            xml.append("<map name=\"").append(mapConfig.getName()).append("\">");
            xml.append("<in-memory-format>").append((Object)mapConfig.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("<backup-count>").append(mapConfig.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(mapConfig.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("<time-to-live-seconds>").append(mapConfig.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(mapConfig.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<eviction-policy>").append((Object)mapConfig.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<max-size policy=\"").append((Object)mapConfig.getMaxSizeConfig().getMaxSizePolicy()).append("\">").append(mapConfig.getMaxSizeConfig().getSize()).append("</max-size>");
            xml.append("<eviction-percentage>").append(mapConfig.getEvictionPercentage()).append("</eviction-percentage>");
            xml.append("<merge-policy>").append(mapConfig.getMergePolicy()).append("</merge-policy>");
            xml.append("<read-backup-data>").append(mapConfig.isReadBackupData()).append("</read-backup-data>");
            xml.append("<statistics-enabled>").append(mapConfig.isStatisticsEnabled()).append("</statistics-enabled>");
            if (mapConfig.getMapStoreConfig() != null) {
                String string;
                MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
                xml.append("<map-store enabled=\"").append(mapStoreConfig.isEnabled()).append("\">");
                String string2 = mapStoreConfig.getImplementation() != null ? mapStoreConfig.getImplementation().getClass().getName() : mapStoreConfig.getClassName();
                xml.append("<class-name>").append(string2).append("</class-name>");
                String string3 = string = mapStoreConfig.getFactoryImplementation() != null ? mapStoreConfig.getFactoryImplementation().getClass().getName() : mapStoreConfig.getFactoryClassName();
                if (string != null) {
                    xml.append("<factory-class-name>").append(string).append("</factory-class-name>");
                }
                xml.append("<write-delay-seconds>").append(mapStoreConfig.getWriteDelaySeconds()).append("</write-delay-seconds>");
                this.appendProperties(xml, mapStoreConfig.getProperties());
                xml.append("</map-store>");
            }
            if (mapConfig.getNearCacheConfig() != null) {
                NearCacheConfig nearCacheConfig = mapConfig.getNearCacheConfig();
                xml.append("<near-cache>");
                xml.append("<max-size>").append(nearCacheConfig.getMaxSize()).append("</max-size>");
                xml.append("<time-to-live-seconds>").append(nearCacheConfig.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
                xml.append("<max-idle-seconds>").append(nearCacheConfig.getMaxIdleSeconds()).append("</max-idle-seconds>");
                xml.append("<eviction-policy>").append(nearCacheConfig.getEvictionPolicy()).append("</eviction-policy>");
                xml.append("<invalidate-on-change>").append(nearCacheConfig.isInvalidateOnChange()).append("</invalidate-on-change>");
                xml.append("<in-memory-format>").append((Object)nearCacheConfig.getInMemoryFormat()).append("</in-memory-format>");
                xml.append("</near-cache>");
            }
            if (mapConfig.getWanReplicationRef() != null) {
                WanReplicationRef wanReplicationRef = mapConfig.getWanReplicationRef();
                xml.append("<wan-replication-ref name=\"").append(wanReplicationRef.getName()).append("\">");
                xml.append("<merge-policy>").append(wanReplicationRef.getMergePolicy()).append("</merge-policy>");
                xml.append("</wan-replication-ref>");
            }
            if (!mapConfig.getMapIndexConfigs().isEmpty()) {
                xml.append("<indexes>");
                for (MapIndexConfig mapIndexConfig : mapConfig.getMapIndexConfigs()) {
                    xml.append("<index ordered=\"").append(mapIndexConfig.isOrdered()).append("\">");
                    xml.append(mapIndexConfig.getAttribute());
                    xml.append("</index>");
                }
                xml.append("</indexes>");
            }
            if (!mapConfig.getEntryListenerConfigs().isEmpty()) {
                xml.append("<entry-listeners>");
                for (EntryListenerConfig entryListenerConfig : mapConfig.getEntryListenerConfigs()) {
                    xml.append("<entry-listener include-value=\"").append(entryListenerConfig.isIncludeValue()).append("\" local=\"").append(entryListenerConfig.isLocal()).append("\">");
                    String string = entryListenerConfig.getImplementation() != null ? entryListenerConfig.getImplementation().getClass().getName() : entryListenerConfig.getClassName();
                    xml.append(string);
                    xml.append("</entry-listener>");
                }
                xml.append("</entry-listeners>");
            }
            if (mapConfig.getPartitioningStrategyConfig() != null) {
                xml.append("<partition-strategy>");
                PartitioningStrategyConfig partitioningStrategyConfig = mapConfig.getPartitioningStrategyConfig();
                if (partitioningStrategyConfig.getPartitioningStrategy() != null) {
                    xml.append(partitioningStrategyConfig.getPartitioningStrategy().getClass().getName());
                } else {
                    xml.append(partitioningStrategyConfig.getPartitioningStrategyClass());
                }
                xml.append("</partition-strategy>");
            }
            xml.append("</map>");
        }
        Collection<MultiMapConfig> collection2 = config.getMultiMapConfigs().values();
        for (MultiMapConfig multiMapConfig : collection2) {
            xml.append("<multimap name=\"").append(multiMapConfig.getName()).append("\">");
            xml.append("<value-collection-type>").append((Object)multiMapConfig.getValueCollectionType()).append("</value-collection-type>");
            if (!multiMapConfig.getEntryListenerConfigs().isEmpty()) {
                xml.append("<entry-listeners>");
                for (EntryListenerConfig entryListenerConfig : multiMapConfig.getEntryListenerConfigs()) {
                    xml.append("<entry-listener include-value=\"").append(entryListenerConfig.isIncludeValue()).append("\" local=\"").append(entryListenerConfig.isLocal()).append("\">");
                    clazz = entryListenerConfig.getImplementation() != null ? entryListenerConfig.getImplementation().getClass().getName() : entryListenerConfig.getClassName();
                    xml.append(clazz);
                    xml.append("</entry-listener>");
                }
                xml.append("</entry-listeners>");
            }
            xml.append("</multimap>");
        }
        Collection<TopicConfig> collection3 = config.getTopicConfigs().values();
        for (TopicConfig topicConfig : collection3) {
            xml.append("<topic name=\"").append(topicConfig.getName()).append("\">");
            xml.append("<global-ordering-enabled>").append(topicConfig.isGlobalOrderingEnabled()).append("</global-ordering-enabled>");
            if (!topicConfig.getMessageListenerConfigs().isEmpty()) {
                xml.append("<message-listeners>");
                for (ListenerConfig lc : topicConfig.getMessageListenerConfigs()) {
                    xml.append("<message-listener>");
                    String clazz4 = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz4);
                    xml.append("</message-listener>");
                }
                xml.append("</message-listeners>");
            }
            xml.append("</topic>");
        }
        Collection<SemaphoreConfig> collection4 = config.getSemaphoreConfigs();
        for (SemaphoreConfig semaphoreConfig : collection4) {
            xml.append("<semaphore name=\"").append(semaphoreConfig.getName()).append("\">");
            xml.append("<initial-permits>").append(semaphoreConfig.getInitialPermits()).append("</initial-permits>");
            xml.append("<backup-count>").append(semaphoreConfig.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(semaphoreConfig.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("</semaphore>");
        }
        if (!config.getListenerConfigs().isEmpty()) {
            xml.append("<listeners>");
            for (ListenerConfig listenerConfig : config.getListenerConfigs()) {
                xml.append("<listener>");
                clazz = listenerConfig.getImplementation() != null ? listenerConfig.getImplementation().getClass().getName() : listenerConfig.getClassName();
                xml.append(clazz);
                xml.append("</listener>");
            }
            xml.append("</listeners>");
        }
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", indent);
            }
            catch (IllegalArgumentException e) {
                logger.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            catch (IllegalArgumentException e) {
                logger.finest("Failed to set indent-amount property; cause: " + e.getMessage());
            }
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            logger.warning(e);
            return input;
        }
    }

    private void appendProperties(StringBuilder xml, Properties props) {
        if (!props.isEmpty()) {
            xml.append("<properties>");
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                xml.append("<property name=\"").append(key).append("\">").append(props.getProperty(key.toString())).append("</property>");
            }
            xml.append("</properties>");
        }
    }
}

