/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.Permit;
import com.hazelcast.concurrent.semaphore.SemaphoreDeadMemberOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreProxy;
import com.hazelcast.concurrent.semaphore.SemaphoreReplicationOperation;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SemaphoreService
implements ManagedService,
MigrationAwareService,
MembershipAwareService,
RemoteService,
ClientAwareService {
    public static final String SERVICE_NAME = "hz:impl:semaphoreService";
    private final ConcurrentMap<String, Permit> permitMap = new ConcurrentHashMap<String, Permit>();
    private final NodeEngine nodeEngine;
    private final ConstructorFunction<String, Permit> permitConstructor = new ConstructorFunction<String, Permit>(){

        @Override
        public Permit createNew(String name) {
            SemaphoreConfig config = SemaphoreService.this.nodeEngine.getConfig().findSemaphoreConfig(name);
            int partitionId = SemaphoreService.this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            return new Permit(partitionId, new SemaphoreConfig(config));
        }
    };

    public SemaphoreService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public Permit getOrCreatePermit(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.permitMap, name, this.permitConstructor);
    }

    public boolean containsSemaphore(String name) {
        return this.permitMap.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.permitMap.clear();
    }

    @Override
    public void shutdown() {
        this.permitMap.clear();
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        String caller = event.getMember().getUuid();
        this.onOwnerDisconnected(caller);
    }

    private void onOwnerDisconnected(String caller) {
        for (String name : this.permitMap.keySet()) {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            InternalPartition info = this.nodeEngine.getPartitionService().getPartition(partitionId);
            if (!this.nodeEngine.getThisAddress().equals(info.getOwner())) continue;
            Operation op = new SemaphoreDeadMemberOperation(name, caller).setPartitionId(partitionId).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler()).setService(this).setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME);
            this.nodeEngine.getOperationService().executeOperation(op);
        }
    }

    @Override
    public SemaphoreProxy createDistributedObject(String objectId) {
        return new SemaphoreProxy(objectId, this, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String objectId) {
        this.permitMap.remove(objectId);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, Permit> migrationData = new HashMap<String, Permit>();
        for (Map.Entry entry : this.permitMap.entrySet()) {
            String name = (String)entry.getKey();
            Permit permit = (Permit)entry.getValue();
            if (permit.getPartitionId() != event.getPartitionId() || permit.getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, permit);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new SemaphoreReplicationOperation(migrationData);
    }

    public void insertMigrationData(Map<String, Permit> migrationData) {
        this.permitMap.putAll(migrationData);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    private void clearMigrationData(int partitionId) {
        Iterator iter = this.permitMap.entrySet().iterator();
        while (iter.hasNext()) {
            Permit permit = (Permit)iter.next().getValue();
            if (permit.getPartitionId() != partitionId) continue;
            iter.remove();
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearMigrationData(partitionId);
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.onOwnerDisconnected(clientUuid);
    }
}

