/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberInfoUpdateOperation;
import com.hazelcast.cluster.PostJoinOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FinalizeJoinOperation
extends MemberInfoUpdateOperation
implements JoinOperation {
    private PostJoinOperation postJoinOp;

    public FinalizeJoinOperation() {
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime) {
        super(members, masterTime, true);
        this.postJoinOp = postJoinOp;
    }

    @Override
    public void run() throws Exception {
        if (this.isValid()) {
            this.processMemberUpdate();
            ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
            NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
            Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
            ArrayList<Future> calls = null;
            if (postJoinOperations != null && postJoinOperations.length > 0) {
                Collection<MemberImpl> members = clusterService.getMemberList();
                calls = new ArrayList<Future>(members.size());
                for (MemberImpl member : members) {
                    if (member.localMember()) continue;
                    Future f = nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", (Operation)new PostJoinOperation(postJoinOperations), member.getAddress()).setTryCount(10).setTryPauseMillis(100L).build().invoke();
                    calls.add(f);
                }
            }
            if (this.postJoinOp != null) {
                this.postJoinOp.setNodeEngine(nodeEngine);
                OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
                OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
                this.postJoinOp.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                nodeEngine.getOperationService().runOperation(this.postJoinOp);
            }
            if (calls != null) {
                for (Future f : calls) {
                    try {
                        f.get(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException member) {
                    }
                    catch (TimeoutException member) {
                    }
                    catch (ExecutionException e) {
                        ILogger logger = nodeEngine.getLogger(FinalizeJoinOperation.class);
                        logger.finest("Error while executing post-join operations -> " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
                    }
                }
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOperation();
            this.postJoinOp.readData(in);
        }
    }
}

