/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionContextImpl;
import com.hazelcast.transaction.impl.TransactionImpl;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private final TransactionManagerServiceImpl transactionManager;
    private final TransactionContextImpl transactionContext;
    private final ILogger logger;
    private int transactionTimeoutSeconds;

    public XAResourceImpl(TransactionManagerServiceImpl transactionManager, TransactionContextImpl transactionContext, NodeEngineImpl nodeEngine) {
        this.transactionManager = transactionManager;
        this.transactionContext = transactionContext;
        this.logger = nodeEngine.getLogger(XAResourceImpl.class);
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        this.nullCheck(xid);
        switch (flags) {
            case 0: {
                if (this.getTransaction(xid) != null) {
                    XAException xaException = new XAException(-8);
                    this.logger.severe("Duplicate xid: " + xid, xaException);
                    throw xaException;
                }
                try {
                    Transaction transaction = this.getTransaction();
                    this.transactionManager.addManagedTransaction(xid, transaction);
                    transaction.begin();
                    break;
                }
                catch (IllegalStateException e) {
                    throw new XAException(-5);
                }
            }
            case 0x200000: 
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        this.nullCheck(xid);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        SerializableXID sXid = transaction.getXid();
        if (sXid == null || !sXid.equals(xid)) {
            this.logger.severe("started xid: " + sXid + " and given xid : " + xid + " not equal!!!");
        }
        this.validateTx(transaction, Transaction.State.ACTIVE);
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                try {
                    transaction.rollback();
                    this.transactionManager.removeManagedTransaction(xid);
                    break;
                }
                catch (IllegalStateException e) {
                    throw new XAException(-3);
                }
            }
            case 0x2000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        this.nullCheck(xid);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        SerializableXID sXid = transaction.getXid();
        if (sXid == null || !sXid.equals(xid)) {
            this.logger.severe("started xid: " + sXid + " and given xid : " + xid + " not equal!!!");
        }
        this.validateTx(transaction, Transaction.State.ACTIVE);
        try {
            transaction.prepare();
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this.nullCheck(xid);
        Transaction transaction = this.getTransaction(xid);
        if (onePhase) {
            this.validateTx(transaction, Transaction.State.ACTIVE);
            transaction.prepare();
        }
        this.validateTx(transaction, Transaction.State.PREPARED);
        try {
            transaction.commit();
            this.transactionManager.removeManagedTransaction(xid);
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        this.nullCheck(xid);
        Transaction transaction = this.getTransaction(xid);
        this.validateTx(transaction, Transaction.State.NO_TXN);
        try {
            transaction.rollback();
            this.transactionManager.removeManagedTransaction(xid);
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public synchronized void forget(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    @Override
    public synchronized boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof XAResourceImpl) {
            XAResourceImpl other = (XAResourceImpl)xaResource;
            return this.transactionManager.equals(other.transactionManager);
        }
        return false;
    }

    @Override
    public synchronized Xid[] recover(int flag) throws XAException {
        return this.transactionManager.recover();
    }

    @Override
    public synchronized int getTransactionTimeout() throws XAException {
        return this.transactionTimeoutSeconds;
    }

    @Override
    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        this.transactionTimeoutSeconds = seconds;
        return false;
    }

    private void nullCheck(Xid xid) throws XAException {
        if (xid == null) {
            XAException xaException = new XAException(-5);
            this.logger.severe("Xid cannot be null!!!", xaException);
            throw xaException;
        }
    }

    private void validateTx(Transaction tx, Transaction.State state) throws XAException {
        if (tx == null) {
            XAException xaException = new XAException(-4);
            this.logger.severe("Transaction is not available!!!", xaException);
            throw xaException;
        }
        Transaction.State txState = tx.getState();
        switch (state) {
            case ACTIVE: {
                if (txState == Transaction.State.ACTIVE) break;
                XAException xaException = new XAException(-4);
                this.logger.severe("Transaction is not active!!! state: " + (Object)((Object)txState), xaException);
                throw xaException;
            }
            case PREPARED: {
                if (txState == Transaction.State.PREPARED) break;
                XAException xaException = new XAException(-5);
                this.logger.severe("Transaction is not prepared!!! state: " + (Object)((Object)txState), xaException);
                throw xaException;
            }
        }
    }

    private Transaction getTransaction(Xid xid) {
        return this.transactionManager.getManagedTransaction(xid);
    }

    private Transaction getTransaction() {
        return this.transactionContext.getTransaction();
    }

    public String toString() {
        String txnId = this.transactionContext.getTxnId();
        StringBuilder sb = new StringBuilder("XAResourceImpl{");
        sb.append("txdId=").append(txnId);
        sb.append(", transactionTimeoutSeconds=").append(this.transactionTimeoutSeconds);
        sb.append('}');
        return sb.toString();
    }
}

